/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.HMRaster;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.modules.r.summary.OmsRasterSummary;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.hmachine.modules.network.PfafstetterNumber;
import org.hortonmachine.hmachine.modules.network.networkattributes.OmsNetworkAttributesBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to prepare input data for the Geoframe modelling environment.")
@Author(name="Antonello Andrea, Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="geoframe")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_GeoframeInputsBuilder")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GeoframeInputsBuilder
extends HMModel {
    @Description(value="Input pitfiller raster map.")
    @UI(value="infile_raster")
    @In
    public String inPitfiller = null;
    @Description(value="Input flowdirections raster map.")
    @UI(value="infile_raster")
    @In
    public String inDrain = null;
    @Description(value="Input tca raster map.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="Input network raster map.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="Input skyview factor raster map.")
    @UI(value="infile_raster")
    @In
    public String inSkyview = null;
    @Description(value="Input numbered basins raster map.")
    @UI(value="infile_raster")
    @In
    public String inBasins = null;
    @Description(value="Optional input lakes vector map.")
    @UI(value="infile_vector")
    @In
    public String inLakes = null;
    @Description(value="The geoframe topology file, mandatory in case of lakes.")
    @UI(value="infile")
    @In
    public String inGeoframeTopology = null;
    @Description(value="Ratio between the velocity in the channel and in the hillslope.")
    @In
    public double pRatio = 50.0;
    @Description(value="Output folder for the geoframe data preparation")
    @UI(value="infolder")
    @In
    public String outFolder = null;
    private boolean doOverWrite = true;
    private boolean useHack = true;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inPitfiller, this.inDrain, this.inTca, this.inNet, this.inSkyview, this.inBasins, this.outFolder});
        try (HMRaster subBasins = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inBasins));
             HMRaster pit = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inPitfiller));
             HMRaster sky = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inSkyview));
             HMRaster drain = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inDrain));
             HMRaster net = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inNet));
             HMRaster tca = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inTca));){
            File csvFile;
            File netShpFile;
            if (this.inGeoframeTopology != null) {
                TreeSet<Integer> subBasinsSet = new TreeSet<Integer>();
                subBasins.process(this.pm, "Check basin ids...", (col, row, value, cols, rows) -> {
                    if (!subBasins.isNovalue(value)) {
                        subBasinsSet.add((int)value);
                    }
                });
                TreeSet<Integer> topologyBasinsSet = new TreeSet<Integer>();
                List topologyLines = FileUtilities.readFileToLinesList((String)this.inGeoframeTopology);
                for (String line : topologyLines) {
                    String[] lineSplit = line.trim().split("\\s+");
                    if (lineSplit.length != 2) {
                        throw new ModelsIllegalargumentException("The topology file format is not recognised for line: " + line, (Object)this);
                    }
                    int currentBasinId = Integer.parseInt(lineSplit[0]);
                    int childBasinId = Integer.parseInt(lineSplit[1]);
                    topologyBasinsSet.add(childBasinId);
                    topologyBasinsSet.add(currentBasinId);
                }
                topologyBasinsSet.remove(0);
                if (subBasinsSet.size() != topologyBasinsSet.size()) {
                    this.printSubbasins(subBasinsSet, topologyBasinsSet);
                    throw new ModelsIllegalargumentException("The topology basins and raster subbasins differ: " + topologyBasinsSet.size() + " vs. " + subBasinsSet.size(), (Object)this);
                }
                for (Integer topoId : topologyBasinsSet) {
                    if (subBasinsSet.contains(topoId)) continue;
                    this.printSubbasins(subBasinsSet, topologyBasinsSet);
                    throw new ModelsIllegalargumentException("The topology basins contain an id that is not available in the raster subbasins: " + topoId, (Object)this);
                }
                this.pm.message("Found basin ids between " + subBasinsSet.first() + " and " + subBasinsSet.last());
            }
            CoordinateReferenceSystem crs = subBasins.getCrs();
            List cells = CoverageUtilities.gridcoverageToValuesAggregatedPolygons((HMRaster)subBasins, (IHMProgressMonitor)this.pm);
            ArrayList<Geometry> lakesList = new ArrayList<Geometry>();
            if (this.inLakes != null) {
                SimpleFeatureCollection lakesFC = this.getVector(this.inLakes);
                List lakesFList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)lakesFC);
                Polygon rasterBounds = FeatureUtilities.envelopeToPolygon((Envelope)pit.getRegionMap().toEnvelope());
                for (SimpleFeature lakeF : lakesFList) {
                    Geometry lakeGeom = (Geometry)lakeF.getDefaultGeometry();
                    Envelope env = lakeGeom.getEnvelopeInternal();
                    if (!rasterBounds.getEnvelopeInternal().intersects(env)) continue;
                    lakesList.add(lakeGeom);
                }
            }
            OmsNetworkAttributesBuilder netAttributesBuilder = new OmsNetworkAttributesBuilder();
            netAttributesBuilder.pm = this.pm;
            netAttributesBuilder.inDem = pit.buildCoverage();
            netAttributesBuilder.inFlow = drain.buildCoverage();
            netAttributesBuilder.inTca = tca.buildCoverage();
            netAttributesBuilder.inNet = net.buildCoverage();
            netAttributesBuilder.doHack = true;
            netAttributesBuilder.onlyDoSimpleGeoms = false;
            netAttributesBuilder.process();
            SimpleFeatureCollection outNet = netAttributesBuilder.outNet;
            String userDataField = this.useHack ? "hack" : "pfaf";
            ArrayList<Geometry> netGeometries = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)outNet, (boolean)true, (String)userDataField);
            Map<Integer, List<Geometry>> collected = cells.parallelStream().filter(poly -> ((Number)poly.getUserData()).doubleValue() != -9999.0).collect(Collectors.groupingBy(poly -> ((Number)poly.getUserData()).intValue()));
            SimpleFeatureBuilder basinsBuilder = this.getBasinsBuilder(pit.getCrs());
            SimpleFeatureBuilder basinCentroidsBuilder = this.getBasinCentroidsBuilder(pit.getCrs());
            SimpleFeatureBuilder singleNetBuilder = this.getSingleNetBuilder(pit.getCrs());
            DefaultFeatureCollection allBasinsFC = new DefaultFeatureCollection();
            DefaultFeatureCollection allNetworksFC = new DefaultFeatureCollection();
            StringBuilder csvText = new StringBuilder();
            csvText.append("#id;x;y;elev_m;avgelev_m;area_km2;netlength;centroid_skyview\n");
            HashMap<Integer, Geometry> basinId2geomMap = new HashMap<Integer, Geometry>();
            this.pm.beginTask("Join basin cells...", collected.size());
            int maxBasinNum = 0;
            for (Map.Entry<Integer, List<Geometry>> entry2 : collected.entrySet()) {
                int basinNum = entry2.getKey();
                maxBasinNum = Math.max(maxBasinNum, basinNum);
                List<Geometry> polygons = entry2.getValue();
                Geometry basin = CascadedPolygonUnion.union(polygons);
                double maxArea = Double.NEGATIVE_INFINITY;
                Geometry maxPolygon = basin;
                int numGeometries = basin.getNumGeometries();
                if (numGeometries > 1) {
                    for (int i = 0; i < numGeometries; ++i) {
                        Geometry geometryN = basin.getGeometryN(i);
                        double area = geometryN.getArea();
                        if (!(area > maxArea)) continue;
                        maxArea = area;
                        maxPolygon = geometryN;
                    }
                }
                for (Geometry lakeGeom : lakesList) {
                    if (!maxPolygon.contains(lakeGeom)) continue;
                    throw new ModelsIllegalargumentException("A basin can't completely contain a lake. Check your data.", (Object)this);
                }
                if (maxPolygon.isValid() && !maxPolygon.isEmpty()) {
                    basinId2geomMap.put(basinNum, maxPolygon);
                } else {
                    this.pm.errorMessage("Not adding basin polygon: valid=" + maxPolygon.isValid() + " empyt=" + maxPolygon.isEmpty());
                }
                this.pm.worked(1);
            }
            this.pm.done();
            for (Geometry lakeGeom : lakesList) {
                PreparedGeometry preparedLake = PreparedGeometryFactory.prepare((Geometry)lakeGeom);
                boolean hasPoint = false;
                for (Geometry netGeom : netGeometries) {
                    LineString line = (LineString)netGeom;
                    Point startPoint = line.getStartPoint();
                    Point endPoint = line.getEndPoint();
                    if (!preparedLake.contains((Geometry)startPoint) && !preparedLake.contains((Geometry)endPoint)) continue;
                    hasPoint = true;
                    break;
                }
                if (hasPoint) continue;
                throw new ModelsIllegalargumentException("A lake has to contain at least one confluence. Check your data.", (Object)this);
            }
            ArrayList<Integer> lakesIdList = new ArrayList<Integer>();
            if (!lakesList.isEmpty()) {
                ArrayList<Basin> allBasins = new ArrayList<Basin>();
                int nextBasinNum = maxBasinNum + 1;
                Basin rootBasin = this.getRootBasin(basinId2geomMap, allBasins);
                if (rootBasin != null) {
                    List nullGeomBasins = allBasins.parallelStream().filter(tmpBasin -> tmpBasin.basinGeometry == null).collect(Collectors.toList());
                    if (nullGeomBasins.size() > 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("The following basins have corrupted or null geometries:");
                        for (Basin nullBasin : nullGeomBasins) {
                            sb.append(nullBasin).append("\n");
                        }
                        sb.append("Unexpected behaviour could occurr, better check your input data.");
                        this.pm.errorMessage(sb.toString());
                    }
                    this.pm.beginTask("Handle lake-basin intersections...", lakesList.size());
                    for (Geometry lakeGeom : lakesList) {
                        Geometry newGeom;
                        Basin outBasin = this.findFirstIntersecting(rootBasin, lakeGeom);
                        if (outBasin == null) continue;
                        List<Basin> intersectingBasins = allBasins.parallelStream().filter(tmpBasin -> {
                            if (tmpBasin.basinGeometry == null) {
                                return false;
                            }
                            boolean isNotOutBasin = tmpBasin.id != outBasin.id;
                            boolean intersectsLake = tmpBasin.basinGeometry.intersects(lakeGeom);
                            return isNotOutBasin && intersectsLake;
                        }).collect(Collectors.toList());
                        ArrayList completelyContainedBasins = new ArrayList();
                        ArrayList justIntersectingBasins = new ArrayList();
                        intersectingBasins.forEach(interBasin -> {
                            if (lakeGeom.contains(interBasin.basinGeometry)) {
                                completelyContainedBasins.add(interBasin);
                            } else {
                                justIntersectingBasins.add(interBasin);
                            }
                        });
                        intersectingBasins = justIntersectingBasins;
                        Basin lakeBasin = new Basin();
                        lakeBasin.basinGeometry = lakeGeom;
                        lakeBasin.id = nextBasinNum++;
                        lakesIdList.add(lakeBasin.id);
                        lakeBasin.downStreamBasin = outBasin;
                        lakeBasin.downStreamBasinId = outBasin.id;
                        lakeBasin.upStreamBasins.addAll(intersectingBasins);
                        basinId2geomMap.put(lakeBasin.id, lakeBasin.basinGeometry);
                        for (Basin containedBasin : completelyContainedBasins) {
                            for (Basin tmpBasin2 : allBasins) {
                                if (tmpBasin2.id == containedBasin.id) continue;
                                if (tmpBasin2.downStreamBasinId == containedBasin.id) {
                                    tmpBasin2.downStreamBasinId = lakeBasin.id;
                                    tmpBasin2.downStreamBasin = lakeBasin;
                                }
                                Basin removeBasin = null;
                                if (tmpBasin2.upStreamBasins != null) {
                                    for (Basin tmpUpBasin : tmpBasin2.upStreamBasins) {
                                        if (tmpUpBasin.id != containedBasin.id) continue;
                                        removeBasin = tmpUpBasin;
                                    }
                                }
                                if (removeBasin == null) continue;
                                tmpBasin2.upStreamBasins.remove(removeBasin);
                                tmpBasin2.upStreamBasins.add(lakeBasin);
                            }
                            containedBasin.downStreamBasin = null;
                            containedBasin.upStreamBasins = null;
                            basinId2geomMap.remove(containedBasin.id);
                        }
                        outBasin.upStreamBasins.removeAll(lakeBasin.upStreamBasins);
                        outBasin.upStreamBasins.add(lakeBasin);
                        Geometry geomToCut = (Geometry)basinId2geomMap.get(outBasin.id);
                        try {
                            newGeom = geomToCut.difference(lakeGeom);
                        }
                        catch (Exception e) {
                            File folder = new File(this.outFolder);
                            File errorFile = new File(folder, "errors.gpkg#error_basin_" + outBasin.id);
                            String message = "An error occurred during intersection between basin and lake geometries. IGNORING LAKE.\nGeometries written to: " + errorFile;
                            this.pm.errorMessage(message);
                            geomToCut.setUserData((Object)("basin_" + outBasin.id));
                            lakeGeom.setUserData((Object)"lake");
                            SimpleFeatureCollection fc = FeatureUtilities.featureCollectionFromGeometry((CoordinateReferenceSystem)crs, (Geometry[])new Geometry[]{geomToCut, lakeGeom});
                            OmsVectorWriter.writeVector((String)errorFile.getAbsolutePath(), (SimpleFeatureCollection)fc);
                            continue;
                        }
                        outBasin.basinGeometry = newGeom;
                        basinId2geomMap.put(outBasin.id, newGeom);
                        intersectingBasins.forEach(iBasin -> {
                            iBasin.downStreamBasin = lakeBasin;
                            iBasin.downStreamBasinId = lakeBasin.id;
                            Geometry basinGeomToCut = (Geometry)basinId2geomMap.get(iBasin.id);
                            Geometry newBasinGeom = basinGeomToCut.difference(lakeGeom);
                            basinId2geomMap.put(iBasin.id, newBasinGeom);
                        });
                        ArrayList<Geometry> cutNetGeometries = new ArrayList<Geometry>();
                        for (Geometry netGeom : netGeometries) {
                            if (netGeom.intersects(lakeGeom)) {
                                Geometry difference = netGeom.difference(lakeGeom);
                                if (difference.isEmpty()) continue;
                                if (difference.getNumGeometries() > 1) {
                                    Geometry longest = null;
                                    double maxLength = -1.0;
                                    for (int i = 0; i < difference.getNumGeometries(); ++i) {
                                        Geometry geometryN = difference.getGeometryN(i);
                                        double l = geometryN.getLength();
                                        if (!(l > maxLength)) continue;
                                        maxLength = l;
                                        longest = geometryN;
                                    }
                                    difference = longest;
                                }
                                cutNetGeometries.add(difference);
                                difference.setUserData(netGeom.getUserData());
                                continue;
                            }
                            cutNetGeometries.add(netGeom);
                        }
                        netGeometries = cutNetGeometries;
                    }
                    File topoFile = new File(this.inGeoframeTopology);
                    String topoFilename = FileUtilities.getNameWithoutExtention((File)topoFile);
                    File newTopoFile = new File(topoFile.getParentFile(), topoFilename + "_lakes.txt");
                    ArrayList<String> topology = new ArrayList<String>();
                    StringBuilder errorSb = new StringBuilder("Not adding again: \n");
                    this.writeTopology(topology, rootBasin, errorSb);
                    StringBuilder sb = new StringBuilder();
                    topology.forEach(record -> sb.append((String)record).append("\n"));
                    String error = errorSb.toString();
                    if (!error.isBlank()) {
                        sb.append("\n\n\n").append(error);
                    }
                    FileUtilities.writeFile((String)sb.toString(), (File)newTopoFile);
                } else {
                    this.pm.errorMessage("Unable to find the basin topology.");
                }
            }
            this.pm.beginTask("Extract vector basins...", basinId2geomMap.size());
            ArrayList<Geometry> _netGeometries = netGeometries;
            basinId2geomMap.entrySet().stream().forEach(entry -> {
                try {
                    this.extractBasin(subBasins, pit, sky, drain, net, crs, (List<Geometry>)_netGeometries, basinsBuilder, basinCentroidsBuilder, singleNetBuilder, allBasinsFC, allNetworksFC, csvText, (List<Integer>)lakesIdList, (Map.Entry<Integer, Geometry>)entry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            this.pm.done();
            File folder = new File(this.outFolder);
            File basinShpFile = new File(folder, "subbasins_complete.shp");
            if (!basinShpFile.exists() || this.doOverWrite) {
                this.dumpVector((SimpleFeatureCollection)allBasinsFC, basinShpFile.getAbsolutePath());
            }
            if (!(netShpFile = new File(folder, "network_complete.shp")).exists() || this.doOverWrite) {
                this.dumpVector((SimpleFeatureCollection)allNetworksFC, netShpFile.getAbsolutePath());
            }
            if (!(csvFile = new File(folder, "subbasins.csv")).exists() || this.doOverWrite) {
                FileUtilities.writeFile((String)csvText.toString(), (File)csvFile);
            }
        }
    }

    private void extractBasin(HMRaster subBasins, HMRaster pit, HMRaster sky, HMRaster drain, HMRaster net, CoordinateReferenceSystem crs, List<Geometry> netGeometries, SimpleFeatureBuilder basinsBuilder, SimpleFeatureBuilder basinCentroidsBuilder, SimpleFeatureBuilder singleNetBuilder, DefaultFeatureCollection allBasinsFC, DefaultFeatureCollection allNetworksFC, StringBuilder csvText, List<Integer> lakesIdList, Map.Entry<Integer, Geometry> entry) throws Exception, ModelsIOException {
        int basinNum = entry.getKey();
        Geometry basinPolygon = entry.getValue();
        double mainNetLength = 0.0;
        ArrayList<LineString> netPieces = new ArrayList<LineString>();
        ArrayList<Integer> checkValueList = new ArrayList<Integer>();
        boolean isLake = lakesIdList.contains(basinNum);
        if (!isLake) {
            int minCheckValue = Integer.MAX_VALUE;
            HashMap<Integer, ArrayList<LineString>> checkValueList4Lines = new HashMap<Integer, ArrayList<LineString>>();
            for (Geometry netGeom : netGeometries) {
                int checkValue;
                LengthIndexedLine lil;
                Coordinate centerCoord;
                double value;
                if (!netGeom.intersects(basinPolygon) || (int)(value = subBasins.getValue(centerCoord = (lil = new LengthIndexedLine(netGeom)).extractPoint(0.5))) != basinNum) continue;
                Object userData = netGeom.getUserData();
                if (this.useHack) {
                    checkValue = Integer.parseInt(userData.toString());
                } else {
                    String pfaf = userData.toString();
                    PfafstetterNumber p = new PfafstetterNumber(pfaf);
                    checkValue = p.getOrder();
                }
                minCheckValue = Math.min(minCheckValue, checkValue);
                checkValueList.add(checkValue);
                ArrayList<LineString> list = (ArrayList<LineString>)checkValueList4Lines.get(checkValue);
                if (list == null) {
                    list = new ArrayList<LineString>();
                }
                list.add((LineString)netGeom);
                checkValueList4Lines.put(checkValue, list);
                netPieces.add((LineString)netGeom);
            }
            if (minCheckValue != Integer.MAX_VALUE) {
                List minCheckValueLines = (List)checkValueList4Lines.get(minCheckValue);
                for (LineString minCheckValueLine : minCheckValueLines) {
                    mainNetLength += minCheckValueLine.getLength();
                }
            }
        }
        Envelope basinEnvelope = basinPolygon.getEnvelopeInternal();
        Point basinCentroid = basinPolygon.getCentroid();
        double areaM2 = basinPolygon.getArea();
        double areaKm2 = areaM2 / 1000000.0;
        Coordinate point = basinCentroid.getCoordinate();
        double elev = pit.getValue(point);
        double skyview = sky.getValue(point);
        ReferencedEnvelope basinRefEnvelope = new ReferencedEnvelope(basinEnvelope, crs);
        GridCoverage2D clipped = CoverageUtilities.clipCoverage((HMRaster)subBasins, (ReferencedEnvelope)basinRefEnvelope, null);
        WritableRaster clippedWR = CoverageUtilities.renderedImage2IntWritableRaster((RenderedImage)clipped.getRenderedImage(), (boolean)false);
        PreparedGeometry preparedBasinPolygon = PreparedGeometryFactory.prepare((Geometry)basinPolygon);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)clipped);
        GridGeometry2D clippedGG = clipped.getGridGeometry();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Coordinate coord = CoverageUtilities.coordinateFromColRow((int)c, (int)r, (GridGeometry2D)clippedGG);
                if (preparedBasinPolygon.intersects((Geometry)GeometryUtilities.gf().createPoint(coord))) {
                    clippedWR.setSample(c, r, 0, basinNum);
                    continue;
                }
                clippedWR.setSample(c, r, 0, -9999);
            }
        }
        File basinFolder = this.makeBasinFolder(basinNum);
        GridCoverage2D maskCoverage = CoverageUtilities.buildCoverage((String)("basin" + basinNum), (WritableRaster)clippedWR, (RegionMap)regionMap, (CoordinateReferenceSystem)crs);
        GridCoverage2D clippedPit = CoverageUtilities.clipCoverage((HMRaster)pit, (ReferencedEnvelope)basinRefEnvelope, null);
        GridCoverage2D cutPit = CoverageUtilities.coverageValuesMapper((GridCoverage2D)clippedPit, (GridCoverage2D)maskCoverage);
        File pitFile = new File(basinFolder, "dtm_" + basinNum + ".asc");
        if (!pitFile.exists() || this.doOverWrite) {
            this.dumpRaster(cutPit, pitFile.getAbsolutePath());
        }
        double[] minMaxAvgSum = OmsRasterSummary.getMinMaxAvgSum((GridCoverage2D)cutPit);
        double avgElev = minMaxAvgSum[2];
        GridCoverage2D clippedSky = CoverageUtilities.clipCoverage((HMRaster)sky, (ReferencedEnvelope)basinRefEnvelope, null);
        GridCoverage2D cutSky = CoverageUtilities.coverageValuesMapper((GridCoverage2D)clippedSky, (GridCoverage2D)maskCoverage);
        File skyFile = new File(basinFolder, "sky_" + basinNum + ".asc");
        if (!skyFile.exists() || this.doOverWrite) {
            this.dumpRaster(cutSky, skyFile.getAbsolutePath());
        }
        GridCoverage2D clippedDrain = CoverageUtilities.clipCoverage((HMRaster)drain, (ReferencedEnvelope)basinRefEnvelope, null);
        GridCoverage2D cutDrain = CoverageUtilities.coverageValuesMapper((GridCoverage2D)clippedDrain, (GridCoverage2D)maskCoverage);
        File drainFile = new File(basinFolder, "drain_" + basinNum + ".asc");
        if (!drainFile.exists() || this.doOverWrite) {
            this.dumpRaster(cutDrain, drainFile.getAbsolutePath());
        }
        GridCoverage2D clippedNet = CoverageUtilities.clipCoverage((HMRaster)net, (ReferencedEnvelope)basinRefEnvelope, null);
        GridCoverage2D cutNet = CoverageUtilities.coverageValuesMapper((GridCoverage2D)clippedNet, (GridCoverage2D)maskCoverage);
        File netFile = new File(basinFolder, "net_" + basinNum + ".asc");
        if (!netFile.exists() || this.doOverWrite) {
            this.dumpRaster(cutNet, netFile.getAbsolutePath());
        }
        Geometry dumpBasin = basinPolygon;
        if (basinPolygon instanceof Polygon) {
            dumpBasin = GeometryUtilities.gf().createMultiPolygon(new Polygon[]{(Polygon)basinPolygon});
        }
        Object[] basinValues = new Object[]{dumpBasin, basinNum, point.x, point.y, elev, avgElev, areaKm2, mainNetLength, skyview, isLake ? 1 : 0};
        basinsBuilder.addAll(basinValues);
        SimpleFeature basinFeature = basinsBuilder.buildFeature(null);
        allBasinsFC.add(basinFeature);
        DefaultFeatureCollection singleBasin = new DefaultFeatureCollection();
        singleBasin.add(basinFeature);
        File basinShpFile = new File(basinFolder, "subbasins_complete_ID_" + basinNum + ".shp");
        if (!basinShpFile.exists() || this.doOverWrite) {
            this.dumpVector((SimpleFeatureCollection)singleBasin, basinShpFile.getAbsolutePath());
        }
        Object[] centroidValues = new Object[]{basinCentroid, basinNum, point.x, point.y, elev, avgElev, areaKm2, mainNetLength, skyview};
        basinCentroidsBuilder.addAll(centroidValues);
        SimpleFeature basinCentroidFeature = basinCentroidsBuilder.buildFeature(null);
        DefaultFeatureCollection singleCentroid = new DefaultFeatureCollection();
        singleCentroid.add(basinCentroidFeature);
        File centroidShpFile = new File(basinFolder, "centroid_ID_" + basinNum + ".shp");
        if (!centroidShpFile.exists() || this.doOverWrite) {
            this.dumpVector((SimpleFeatureCollection)singleCentroid, centroidShpFile.getAbsolutePath());
        }
        if (!netPieces.isEmpty()) {
            DefaultFeatureCollection singleNet = new DefaultFeatureCollection();
            for (int i = 0; i < netPieces.size(); ++i) {
                LineString netLine = (LineString)netPieces.get(i);
                Integer checkValue = (Integer)checkValueList.get(i);
                Object[] netValues = new Object[]{netLine, basinNum, netLine.getLength(), checkValue};
                singleNetBuilder.addAll(netValues);
                SimpleFeature singleNetFeature = singleNetBuilder.buildFeature(null);
                allNetworksFC.add(singleNetFeature);
                singleNet.add(singleNetFeature);
            }
            File netShpFile = new File(basinFolder, "network_complete_ID_" + basinNum + ".shp");
            if (!netShpFile.exists() || this.doOverWrite) {
                this.dumpVector((SimpleFeatureCollection)singleNet, netShpFile.getAbsolutePath());
            }
        }
        csvText.append(basinNum).append(";");
        csvText.append(point.x).append(";");
        csvText.append(point.y).append(";");
        csvText.append(elev).append(";");
        csvText.append(avgElev).append(";");
        csvText.append(areaKm2).append(";");
        csvText.append(mainNetLength).append(";");
        csvText.append(skyview).append("\n");
        this.pm.worked(1);
    }

    private void printSubbasins(TreeSet<Integer> subBasinsSet, TreeSet<Integer> topologyBasinsSet) {
        this.pm.message("Basins in subbasins but not in topology:");
        for (Integer subbasinId : subBasinsSet) {
            if (topologyBasinsSet.contains(subbasinId)) continue;
            this.pm.message("\t->" + subbasinId);
        }
        this.pm.message("Basins in topology but not in subbasins:");
        for (Integer topologyIdId : topologyBasinsSet) {
            if (subBasinsSet.contains(topologyIdId)) continue;
            this.pm.message("\t->" + topologyIdId);
        }
    }

    private Geometry getMaxArea(Geometry newGeom) {
        if (newGeom.getNumGeometries() > 1) {
            Geometry biggest = null;
            double maxArea = -1.0;
            for (int i = 0; i < newGeom.getNumGeometries(); ++i) {
                Geometry geometryN = newGeom.getGeometryN(i);
                double a = geometryN.getArea();
                if (!(a > maxArea)) continue;
                maxArea = a;
                biggest = geometryN;
            }
            newGeom = biggest;
        }
        return newGeom;
    }

    private void writeTopology(List<String> topology, Basin basin, StringBuilder errorSb) {
        String record;
        int downid = 0;
        if (basin.downStreamBasin != null) {
            downid = basin.downStreamBasinId;
        }
        if (!topology.contains(record = basin.id + " " + downid)) {
            topology.add(record);
            for (Basin upBasin : basin.upStreamBasins) {
                this.writeTopology(topology, upBasin, errorSb);
            }
        } else {
            errorSb.append("  ->").append(record).append("\n");
        }
    }

    private Basin findFirstIntersecting(Basin basin, Geometry lakeGeom) {
        if (basin.basinGeometry.intersects(lakeGeom)) {
            return basin;
        }
        for (Basin upBasin : basin.upStreamBasins) {
            Basin firstIntersecting = this.findFirstIntersecting(upBasin, lakeGeom);
            if (firstIntersecting == null) continue;
            return firstIntersecting;
        }
        return null;
    }

    private File makeBasinFolder(int basinNum) throws ModelsIOException {
        File folder = new File(this.outFolder);
        File basinFolder = new File(folder, String.valueOf(basinNum));
        FileUtilities.folderCheckMakeOrDie((String)basinFolder.getAbsolutePath());
        return basinFolder;
    }

    private SimpleFeatureBuilder getBasinsBuilder(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("basin");
        b.setCRS(crs);
        b.add("the_geom", MultiPolygon.class);
        b.add("basinid", Integer.class);
        b.add("centrx", Double.class);
        b.add("centry", Double.class);
        b.add("elev_m", Double.class);
        b.add("avgelev_m", Double.class);
        b.add("area_km2", Double.class);
        b.add("length_m", Double.class);
        b.add("skyview", Double.class);
        b.add("islake", Integer.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        return builder;
    }

    private SimpleFeatureBuilder getBasinCentroidsBuilder(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("basin");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("basinid", Integer.class);
        b.add("centrx", Double.class);
        b.add("centry", Double.class);
        b.add("elev_m", Double.class);
        b.add("avgelev_m", Double.class);
        b.add("area_km2", Double.class);
        b.add("length_m", Double.class);
        b.add("skyview", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        return builder;
    }

    private SimpleFeatureBuilder getSingleNetBuilder(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("net");
        b.setCRS(crs);
        b.add("the_geom", LineString.class);
        b.add("basinid", Integer.class);
        b.add("length_m", Double.class);
        if (this.useHack) {
            b.add("hack", Double.class);
        } else {
            b.add("pfaforder", Double.class);
        }
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        return builder;
    }

    private Basin getRootBasin(Map<Integer, Geometry> basinId2geomMap, List<Basin> allBasins) throws IOException {
        if (this.inGeoframeTopology != null) {
            HashMap<Integer, Basin> id2BasinMap = new HashMap<Integer, Basin>();
            List topologyLines = FileUtilities.readFileToLinesList((String)this.inGeoframeTopology);
            for (String string : topologyLines) {
                String[] lineSplit = string.trim().split("\\s+");
                if (lineSplit.length != 2) {
                    throw new ModelsIllegalargumentException("The topology file format is not recognised for line: " + string, (Object)this);
                }
                int currentBasinId = Integer.parseInt(lineSplit[0]);
                int childBasinId = Integer.parseInt(lineSplit[1]);
                Basin currentBasin = (Basin)id2BasinMap.get(currentBasinId);
                if (currentBasin == null) {
                    currentBasin = new Basin();
                    currentBasin.id = currentBasinId;
                    id2BasinMap.put(currentBasinId, currentBasin);
                }
                if (childBasinId <= 0) continue;
                Basin childBasin = (Basin)id2BasinMap.get(childBasinId);
                if (childBasin != null) {
                    currentBasin.downStreamBasin = childBasin;
                    currentBasin.downStreamBasinId = childBasinId;
                    continue;
                }
                currentBasin.downStreamBasinId = childBasinId;
            }
            for (Map.Entry entry : id2BasinMap.entrySet()) {
                Basin downBasin;
                Basin basin = (Basin)entry.getValue();
                if (basin.downStreamBasin != null || basin.downStreamBasinId <= 0) continue;
                basin.downStreamBasin = downBasin = (Basin)id2BasinMap.get(basin.downStreamBasinId);
            }
            for (Map.Entry entry : id2BasinMap.entrySet()) {
                int id = (Integer)entry.getKey();
                Basin basin = (Basin)entry.getValue();
                for (Basin tmpBasin : id2BasinMap.values()) {
                    if (id == tmpBasin.id || tmpBasin.downStreamBasinId != id || basin.upStreamBasins.contains(tmpBasin)) continue;
                    basin.upStreamBasins.add(tmpBasin);
                }
                Geometry basinGeometry = basinId2geomMap.get(id);
                if (basinGeometry != null) {
                    basin.basinGeometry = basinGeometry;
                    allBasins.add(basin);
                    continue;
                }
                this.pm.errorMessage("Ignoring basin that has null geometry: " + basin.toString());
            }
            Basin rootBasin = id2BasinMap.values().stream().filter(b -> b.downStreamBasinId < 0).findFirst().get();
            return rootBasin;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String path = "/Users/hydrologis/lavori_tmp/UNITN/D_basin_issue/";
        String pit = path + "pf.asc";
        String drain = path + "dd.asc";
        String tca = path + "tca.asc";
        String net = path + "net.asc";
        String sky = path + "sky.asc";
        String basins = path + "dsb.asc";
        String topology = path + "tp";
        String lakes = path + "lago.shp";
        String outfolder = path + "geoframe";
        GeoframeInputsBuilder g = new GeoframeInputsBuilder();
        g.inPitfiller = pit;
        g.inDrain = drain;
        g.inTca = tca;
        g.inNet = net;
        g.inSkyview = sky;
        g.inBasins = basins;
        g.inLakes = lakes;
        g.inGeoframeTopology = topology;
        g.outFolder = outfolder;
        g.process();
    }

    private static class Basin {
        int id = -1;
        int downStreamBasinId = -1;
        Geometry basinGeometry;
        Basin downStreamBasin;
        List<Basin> upStreamBasins = new ArrayList<Basin>();

        private Basin() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Basin other = (Basin)obj;
            return this.id == other.id;
        }

        public String toString() {
            return "Basin [\nid=" + this.id + "\ndownStreamBasinId=" + this.downStreamBasinId + "\nupStreamBasins=" + this.upStreamBasins.stream().map(b -> String.valueOf(b.id)).collect(Collectors.joining(",")) + "\n]";
        }
    }
}

