/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.multitca.OmsMultiTca;

@Description(value="It calculates the contributing areas differently in convex and concave areas")
@Author(name="Andreis Daniele, Erica Ghesla, Antonello Andrea, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="")
@Keywords(value="Geomorphology, OmsDrainDir, Pitfiller, OmsAb")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_multitca")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class MultiTca
extends HMModel {
    @Description(value="The map of depitted elevation.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map with the Thopological classes cp9.")
    @UI(value="infile_raster")
    @In
    public String inCp9 = null;
    @Description(value="The map of total contributing areas.")
    @UI(value="outfile")
    @In
    public String outMultiTca = null;

    @Execute
    public void process() throws Exception {
        OmsMultiTca multitca = new OmsMultiTca();
        multitca.inPit = this.getRaster(this.inPit);
        multitca.inFlow = this.getRaster(this.inFlow);
        multitca.inCp9 = this.getRaster(this.inCp9);
        multitca.pm = this.pm;
        multitca.doProcess = this.doProcess;
        multitca.doReset = this.doReset;
        multitca.process();
        this.dumpRaster(multitca.outMultiTca, this.outMultiTca);
    }
}

