/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.netcdf.OmsNetcdf2GridCoverageConverter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;

@Description(value="Dump NetCDF grids to geotools compatible rasters convering them to lat/lon epsg:4326.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="netdcf")
@Label(value="NetCDF")
@Name(value="_netcdfgriddumper")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class NetcdfGridDumper
extends HMModel {
    @Description(value="The netcdf file or url to dump.")
    @UI(value="infile")
    @In
    public String inPath = null;
    @Description(value="The name of the variable of the grid to dump.")
    @In
    public String pGridName = null;
    @Description(value="In case of no grid name, an inclusion pattern can be used.")
    @In
    public String pIncludePattern = null;
    @Description(value="In case of no grid name, an exclusion pattern can be used.")
    @In
    public String pExcludePattern = null;
    @Description(value="The timestap index from which to start to dump.")
    @In
    public Integer pFromTimestep = 0;
    @Description(value="The timestap index at which to end to dump. If not set defaults to the start index.")
    @In
    public Integer pToTimestep;
    @Description(value="An optional correction on the false easting.")
    @In
    public Double pFalseEastingCorrection = null;
    @Description(value="An optional correction on the false northing.")
    @In
    public Double pFalseNorthingCorrection = null;
    @Description(value="An optional correction of the north pole northing .")
    @In
    public Double pNorthPoleLongitudeCorrection = null;
    @Description(value="An optional correction on the false easting.")
    @In
    public Double pNorthPoleLatitudeCorrection = null;
    @Description(value="The output folder in which to store the dumped rasters.")
    @UI(value="outfolder")
    @Out
    public String outFolder;

    @Execute
    public void process() throws Exception {
        OmsNetcdf2GridCoverageConverter converter = new OmsNetcdf2GridCoverageConverter();
        converter.inPath = this.inPath;
        converter.pGridName = this.pGridName;
        converter.pFromTimestep = this.pFromTimestep;
        converter.pToTimestep = this.pToTimestep;
        converter.pFalseEastingCorrection = this.pFalseEastingCorrection;
        converter.pFalseNorthingCorrection = this.pFalseNorthingCorrection;
        converter.pNorthPoleLatitudeCorrection = this.pNorthPoleLatitudeCorrection;
        converter.pNorthPoleLongitudeCorrection = this.pNorthPoleLongitudeCorrection;
        converter.initProcess();
        while (converter.doProcess) {
            converter.process();
            GridCoverage2D outRaster = converter.outRaster;
            Date date = converter.currentDate;
            SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String tsString = f.format(date);
            File folderFile = new File(this.outFolder);
            File inFile = new File(this.inPath);
            Object name = FileUtilities.getNameWithoutExtention((File)inFile);
            String safeName = FileUtilities.getSafeFileName((String)this.pGridName);
            name = (String)name + "__" + tsString + "__" + safeName + ".tif";
            File outFile = new File(folderFile, (String)name);
            this.dumpRaster(outRaster, outFile.getAbsolutePath());
        }
    }
}

