/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Parameter;

@Description(value="NetdcfInfo command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="netdcf")
@Label(value="NetCDF")
@Name(value="_netcdfinfo")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class NetcdfInfo
extends HMModel {
    @Description(value="The netcdf file or url to check.")
    @UI(value="infile")
    @In
    public String inPath = null;
    public boolean doLongitudeShift = false;

    @Execute
    public void process() throws Exception {
        StringBuilder sb = new StringBuilder();
        File infile = new File(this.inPath);
        if (!infile.exists() && !this.inPath.startsWith("http")) {
            throw new ModelsIllegalargumentException("The input doesn't exist.", (Object)this);
        }
        NetcdfDataset netcdfDataset = NetcdfDataset.acquireDataset((String)this.inPath, null);
        List variables = netcdfDataset.getVariables();
        String NL = "\n";
        String IND = "\t";
        String fileTypeId = netcdfDataset.getFileTypeId();
        String fileTypeVersion = netcdfDataset.getFileTypeVersion();
        String fileTypeDescription = netcdfDataset.getFileTypeDescription();
        String location = netcdfDataset.getLocation();
        String title = netcdfDataset.getTitle();
        sb.append("File ").append(infile.getName()).append(NL);
        sb.append("File type id: ").append(fileTypeId).append(NL);
        sb.append("File type version: ").append(fileTypeVersion).append(NL);
        sb.append("File type description: ").append(fileTypeDescription).append(NL);
        sb.append(NL);
        List globalAttributes = netcdfDataset.getGlobalAttributes();
        sb.append("Global Attributes").append(NL);
        for (Attribute attribute : globalAttributes) {
            sb.append(IND).append(attribute.getFullName()).append(": ").append(attribute.getStringValue()).append(NL);
        }
        sb.append(NL);
        sb.append("Coordinate systems").append(NL);
        List coordinateSystems = netcdfDataset.getCoordinateSystems();
        int i = 1;
        for (Object cs : coordinateSystems) {
            sb.append(IND).append(i++).append(") ").append(cs.getName()).append(": ").append(cs).append(NL);
            sb.append(IND + IND).append("has X/Y CoordAxis + CoordTrans Projection: ").append(cs.isGeoXY()).append(NL);
            sb.append(IND + IND).append("has lat/long CoordAxis: ").append(cs.isLatLon()).append(NL);
            sb.append(IND + IND).append("has radial distance + azimuth CoordAxis: ").append(cs.isRadial()).append(NL);
            sb.append(IND + IND).append("has time Axis: ").append(cs.hasTimeAxis()).append(NL);
        }
        sb.append(NL);
        sb.append("Coordinate Axes").append(NL);
        List coordinateAxes = netcdfDataset.getCoordinateAxes();
        i = 1;
        for (Object ca : coordinateAxes) {
            AxisType axisType = ca.getAxisType();
            List attributes = ca.getAttributes();
            sb.append(IND).append(i++).append(") ").append(ca.getFullName()).append(": ").append(NL);
            sb.append(IND + IND).append("Axis Type: ").append(axisType).append(NL);
            sb.append(IND + IND).append("Class: ").append(ca.getClass().getSimpleName()).append(NL);
            sb.append(IND + IND).append("Attributes: ").append(NL);
            for (Attribute attribute : attributes) {
                String attrName = attribute.getFullName();
                Array attrValue = attribute.getValues();
                sb.append(IND + IND + IND).append(attrName).append(": ").append(attrValue).append(NL);
            }
        }
        List coordinateTransforms = netcdfDataset.getCoordinateTransforms();
        sb.append(NL);
        sb.append("Coordinate Transforms").append(NL);
        i = 1;
        for (CoordinateTransform ct : coordinateTransforms) {
            sb.append(IND).append(i++).append(") ").append(ct.getName()).append(": ").append(NL);
            sb.append(IND + IND).append("Authority").append(": ").append(ct.getAuthority()).append(NL);
            sb.append(IND + IND).append("Transform type").append(": ").append(ct.getTransformType()).append(NL);
            sb.append(IND + IND).append("Parameters").append(": ").append(NL);
            List parameters = ct.getParameters();
            for (Parameter parameter : parameters) {
                sb.append(IND + IND + IND).append(parameter.getName()).append(": ").append(parameter.getStringValue()).append(NL);
            }
        }
        i = 1;
        sb.append("Variables").append(NL);
        for (Variable variable : variables) {
            List ranges;
            Attribute attr2;
            DataType dataType = variable.getDataType();
            String fullName = variable.getFullName();
            String unitsString = variable.getUnitsString();
            boolean isCoordinateVariable = variable.isCoordinateVariable();
            boolean isScalar = variable.isScalar();
            String className = variable.getClass().getSimpleName();
            sb.append(IND).append(i++).append(")").append(fullName).append(": ").append(NL);
            sb.append(IND + IND).append("Class: ").append(className).append(NL);
            sb.append(IND + IND).append("Is coordinate: ").append(isCoordinateVariable).append(NL);
            sb.append(IND + IND).append("Is scalar: ").append(isScalar).append(NL);
            sb.append(IND + IND).append("DataType: ").append(dataType.name()).append(NL);
            sb.append(IND + IND).append("Unit: ").append(unitsString).append(NL);
            List attributes = variable.getAttributes();
            if (attributes.size() > 0) {
                sb.append(IND + IND).append("Attributes: ").append(NL);
                for (Attribute attr2 : attributes) {
                    sb.append(IND + IND + IND).append(attr2.getFullName()).append(" -> ").append(attr2.getStringValue()).append(NL);
                }
            }
            if ((ranges = variable.getRanges()).size() <= 0) continue;
            sb.append(IND + IND).append("Ranges: ").append(NL);
            attr2 = ranges.iterator();
            while (attr2.hasNext()) {
                Range range = (Range)attr2.next();
                sb.append(IND + IND + IND).append(range.first()).append(" -> ").append(range.last()).append(NL);
            }
        }
        this.pm.message(sb.toString());
        sb = new StringBuilder();
        sb.append(NL);
        sb.append("Grid definitions: ").append(NL);
        GridDataset gds = GridDataset.open((String)this.inPath);
        List grids = gds.getGrids();
        i = 0;
        for (GridDatatype grid : grids) {
            List dimensions = grid.getDimensions();
            if (dimensions.size() < 2) continue;
            String gridName = grid.getFullName();
            List attributes = grid.getAttributes();
            sb.append(IND).append(i++).append(") ").append(gridName).append(": ").append(NL);
            sb.append(IND + IND).append("Attributes:").append(NL);
            for (Attribute attribute : attributes) {
                sb.append(IND + IND + IND).append(attribute.getFullName()).append(": ").append(attribute.getStringValue()).append(NL);
            }
            GridCoordSystem coordSys = grid.getCoordinateSystem();
            ProjectionImpl proj = coordSys.getProjection();
            sb.append(IND + IND).append("Projection: ").append(proj).append(NL);
            CoordinateAxis xAxis = coordSys.getXHorizAxis();
            CoordinateAxis yAxis = coordSys.getYHorizAxis();
            double minXValue = xAxis.getMinValue();
            double maxXValue = xAxis.getMaxValue();
            long xSize = xAxis.getSize();
            String fullName = xAxis.getFullName();
            sb.append(IND + IND).append("Proj X Axis (" + fullName + "): ").append(minXValue).append(" -> ").append(maxXValue).append("   (" + xSize + ")").append("  extent: ").append(maxXValue - minXValue).append(NL);
            double minYValue = yAxis.getMinValue();
            double maxYValue = yAxis.getMaxValue();
            long ySize = yAxis.getSize();
            fullName = yAxis.getFullName();
            sb.append(IND + IND).append("Proj Y Axis (" + fullName + "): ").append(minYValue).append(" -> ").append(maxYValue).append("   (" + ySize + ")").append("  extent: ").append(maxYValue - minYValue).append(NL);
            if (coordSys.hasTimeAxis1D()) {
                CoordinateAxis1DTime tAxis1D = coordSys.getTimeAxis1D();
                fullName = tAxis1D.getFullName();
                long tSize = tAxis1D.getSize();
                List dates = tAxis1D.getCalendarDates();
                sb.append(IND + IND).append("Time Axis (" + fullName + "): ").append(dates.get(0)).append(" -> ").append(dates.get(dates.size() - 1)).append("   (" + tSize + ")").append(NL);
            }
            Array xValues = xAxis.read();
            Array yValues = yAxis.read();
            int[] xShape = xValues.getShape();
            int[] yShape = yValues.getShape();
            Index xIndex = xValues.getIndex();
            Index yIndex = yValues.getIndex();
            Envelope env = new Envelope();
            for (int y = 0; y < yShape[0]; ++y) {
                for (int x = 0; x < xShape[0]; ++x) {
                    double xVal = xValues.getDouble(xIndex.set(x));
                    double yVal = yValues.getDouble(yIndex.set(y));
                    double longitude = xVal;
                    double latitude = yVal;
                    if (!(proj instanceof LatLonProjection)) {
                        LatLonPoint latLonPoint = proj.projToLatLon(xVal, yVal);
                        latitude = latLonPoint.getLatitude();
                        longitude = latLonPoint.getLongitude();
                    }
                    env.expandToInclude(new Coordinate(longitude, latitude));
                }
            }
            double lonMin = env.getMinX();
            double latMin = env.getMinY();
            double lonMax = env.getMaxX();
            double latMax = env.getMaxY();
            sb.append(IND + IND).append("Longitude: ").append(lonMin).append(" -> ").append(lonMax).append("  extent: ").append(lonMax - lonMin).append(NL);
            sb.append(IND + IND).append("Latitude: ").append(latMin).append(" -> ").append(latMax).append("  extent: ").append(latMax - latMin).append(NL);
        }
        this.pm.message(sb.toString());
    }

    public static void main(String[] args) throws Exception {
        NetcdfInfo i = new NetcdfInfo();
        i.doLongitudeShift = true;
        i.inPath = "/home/hydrologis/TMP/KLAB/MODIS/MYD09A1.A2022265.h24v03.006.2022274080721.hdf";
        i.process();
    }
}

