/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Envelope2D;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.hortonmachine.modules.RasterReader;
import org.hortonmachine.modules.RasterWriter;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Raster {
    private RegionMap regionMap;
    private CoordinateReferenceSystem crs;
    private RandomIter iter;
    private WritableRaster newWR;
    private final boolean makeNew;
    private final int cols;
    private final int rows;
    private final double west;
    private final double south;
    private final double east;
    private final double north;
    private final double xRes;
    private final double yRes;
    private GridGeometry2D gridGeometry;
    private final double novalue;

    public Raster(GridCoverage2D raster) {
        this(raster, false);
    }

    public Raster(GridCoverage2D raster, boolean makeNew) {
        this.makeNew = makeNew;
        this.crs = raster.getCoordinateReferenceSystem();
        this.regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)raster);
        this.cols = this.regionMap.getCols();
        this.rows = this.regionMap.getRows();
        this.west = this.regionMap.getWest();
        this.south = this.regionMap.getSouth();
        this.east = this.regionMap.getEast();
        this.north = this.regionMap.getNorth();
        this.xRes = (this.east - this.west) / (double)this.cols;
        this.yRes = (this.north - this.south) / (double)this.rows;
        if (makeNew) {
            this.newWR = CoverageUtilities.createWritableRaster((int)this.cols, (int)this.rows, null, null, (Object)-9999.0);
            this.iter = RandomIterFactory.createWritable((WritableRaster)this.newWR, null);
            this.novalue = -9999.0;
        } else {
            this.iter = RandomIterFactory.create((RenderedImage)raster.getRenderedImage(), null);
            this.novalue = HMConstants.getNovalue((GridCoverage2D)raster);
        }
    }

    public Raster(Raster raster) {
        this.makeNew = true;
        this.crs = raster.getCrs();
        this.cols = raster.getCols();
        this.rows = raster.getRows();
        this.west = raster.getWest();
        this.south = raster.getSouth();
        this.east = raster.getEast();
        this.north = raster.getNorth();
        this.xRes = (this.east - this.west) / (double)this.cols;
        this.yRes = (this.north - this.south) / (double)this.rows;
        this.regionMap = new RegionMap();
        this.regionMap.north = this.north;
        this.regionMap.south = this.south;
        this.regionMap.west = this.west;
        this.regionMap.east = this.east;
        this.regionMap.xres = this.xRes;
        this.regionMap.yres = this.yRes;
        this.regionMap.rows = this.rows;
        this.regionMap.cols = this.cols;
        this.newWR = CoverageUtilities.createWritableRaster((int)this.cols, (int)this.rows, null, null, (Object)-9999.0);
        this.iter = RandomIterFactory.createWritable((WritableRaster)this.newWR, null);
        this.novalue = -9999.0;
    }

    public Raster(int cols, int rows, double res, double ulEasting, double ulNorthing, String epsg) {
        this.cols = cols;
        this.rows = rows;
        this.xRes = res;
        this.yRes = res;
        try {
            this.crs = CrsUtilities.getCrsFromEpsg((String)epsg);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get CRS from the given epsg: " + epsg);
        }
        double width = (double)cols * res;
        double height = (double)rows * res;
        this.west = ulEasting;
        this.east = ulEasting + width;
        this.north = ulNorthing;
        this.south = ulNorthing - height;
        this.regionMap = new RegionMap();
        this.regionMap.north = this.north;
        this.regionMap.south = this.south;
        this.regionMap.west = this.west;
        this.regionMap.east = this.east;
        this.regionMap.xres = res;
        this.regionMap.yres = res;
        this.regionMap.rows = rows;
        this.regionMap.cols = cols;
        this.makeNew = true;
        this.newWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
        this.iter = RandomIterFactory.createWritable((WritableRaster)this.newWR, null);
        this.novalue = -9999.0;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public double getNorth() {
        return this.north;
    }

    public double getSouth() {
        return this.south;
    }

    public double getWest() {
        return this.west;
    }

    public double getEast() {
        return this.east;
    }

    public double getxRes() {
        return this.xRes;
    }

    public double getyRes() {
        return this.yRes;
    }

    public double getRes() {
        return this.xRes;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public double valueAt(int col, int row) {
        if (this.isInRaster(col, row)) {
            double value = this.iter.getSampleDouble(col, row, 0);
            return value;
        }
        return this.novalue;
    }

    public double[] positionAt(int col, int row) {
        if (this.isInRaster(col, row)) {
            GridGeometry2D gridGeometry = this.getGridGeometry();
            Coordinate coordinate = CoverageUtilities.coordinateFromColRow((int)col, (int)row, (GridGeometry2D)gridGeometry);
            return new double[]{coordinate.x, coordinate.y};
        }
        return null;
    }

    public int[] gridAt(double x, double y) {
        if (this.isInRaster(x, y)) {
            GridGeometry2D gridGeometry = this.getGridGeometry();
            int[] colRowFromCoordinate = CoverageUtilities.colRowFromCoordinate((Coordinate)new Coordinate(x, y), (GridGeometry2D)gridGeometry, null);
            return colRowFromCoordinate;
        }
        return null;
    }

    public void setValueAt(int col, int row, double value) {
        if (this.makeNew) {
            if (!this.isInRaster(col, row)) {
                throw new RuntimeException("Setting value outside of raster.");
            }
        } else {
            throw new RuntimeException("Writing not allowed.");
        }
        ((WritableRandomIter)this.iter).setSample(col, row, 0, value);
    }

    public double[] surrounding(int col, int row) {
        GridNode node = new GridNode(this.iter, this.cols, this.rows, this.xRes, this.yRes, col, row, Double.valueOf(this.novalue));
        List surroundingNodes = node.getSurroundingNodes();
        double[] surr = new double[8];
        for (int i = 0; i < surroundingNodes.size(); ++i) {
            GridNode gridNode = (GridNode)surroundingNodes.get(i);
            surr[i] = gridNode != null ? gridNode.elevation : this.novalue;
        }
        return surr;
    }

    public boolean isNoValue(double value) {
        return HMConstants.isNovalue((double)value);
    }

    public double novalue() {
        return this.novalue;
    }

    public static boolean valuesEqual(double value1, double value2) {
        return NumericsUtilities.dEq((double)value1, (double)value2);
    }

    public GridGeometry2D getGridGeometry() {
        if (this.gridGeometry == null) {
            Envelope2D envelope = new Envelope2D(this.crs, this.west, this.south, this.east - this.west, this.north - this.south);
            GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, this.cols, this.rows);
            this.gridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)envelope);
        }
        return this.gridGeometry;
    }

    public GridCoverage2D buildRaster() {
        if (this.makeNew) {
            GridCoverage2D coverage = CoverageUtilities.buildCoverage((String)"raster", (WritableRaster)this.newWR, (RegionMap)this.regionMap, (CoordinateReferenceSystem)this.crs);
            return coverage;
        }
        throw new RuntimeException("The raster is readonly, so no new raster can be built.");
    }

    public void write(String path) throws Exception {
        if (!this.makeNew) {
            throw new RuntimeException("Only new rasters can be dumped.");
        }
        RasterWriter.writeRaster(path, this.buildRaster());
    }

    public static Raster read(String path) throws Exception {
        GridCoverage2D coverage2d = RasterReader.readRaster(path);
        Raster raster = new Raster(coverage2d);
        return raster;
    }

    private boolean isInRaster(int col, int row) {
        return col >= 0 && col < this.cols && row >= 0 && row < this.rows;
    }

    private boolean isInRaster(double easting, double northing) {
        return !(easting < this.west || easting > this.east || northing < this.south) && !(northing > this.north);
    }
}

