/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.HMRaster;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.RasterCellInfo;
import org.hortonmachine.gears.utils.math.NumericsUtilities;

@Description(value="Compare two rasters")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Compare, Raster")
@Label(value="Raster Processing")
@Name(value="_rcompare")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterCompare
extends HMModel {
    @Description(value="Raster 1")
    @UI(value="infile_raster")
    @In
    public String inRaster1;
    @Description(value="Raster 2")
    @UI(value="infile_raster")
    @In
    public String inRaster2;
    @Description(value="Test some random pixels")
    @In
    public boolean doPixelTest = false;
    @Description(value="Test pixels bins")
    @In
    public int pTestPixelsBins = 10;
    public static final String OMSRASTERSUMMARY_DESCRIPTION = "Compare two rasters";
    public static final String OMSRASTERSUMMARY_KEYWORDS = "Compare, Raster";
    public static final String OMSRASTERSUMMARY_LABEL = "Raster Processing";
    public static final String OMSRASTERSUMMARY_NAME = "rcompare";
    public static final int OMSRASTERSUMMARY_STATUS = 40;
    public static final String OMSRASTERSUMMARY_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERSUMMARY_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERSUMMARY_AUTHORCONTACTS = "http://www.hydrologis.com";

    @Execute
    public void process() throws Exception {
        HMRaster raster1 = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inRaster1));
        HMRaster raster2 = HMRaster.fromGridCoverage((GridCoverage2D)this.getRaster(this.inRaster2));
        RegionMap regionMap1 = raster1.getRegionMap();
        RegionMap regionMap2 = raster2.getRegionMap();
        StringBuilder sb = new StringBuilder();
        sb.append("\nGRIDGEOMETRY ANALYSIS").append("\n");
        sb.append("================================").append("\n");
        if (regionMap1.equals((Object)regionMap2)) {
            sb.append("Rasters have same bounds and resolution.").append("\n");
        } else if (regionMap1.equalsBounds((Object)regionMap2)) {
            sb.append("Rasters have same bounds but different resolution.").append("\n");
        } else {
            sb.append("Bounds delta:").append("\n");
            sb.append("\twest: " + regionMap1.getWest() + "-" + regionMap2.getWest() + "=" + (regionMap1.getWest() - regionMap2.getWest())).append("\n");
            sb.append("\teast: " + regionMap1.getEast() + "-" + regionMap2.getEast() + "=" + (regionMap1.getEast() - regionMap2.getEast())).append("\n");
            sb.append("\tsouth: " + regionMap1.getSouth() + "-" + regionMap2.getSouth() + "=" + (regionMap1.getSouth() - regionMap2.getSouth())).append("\n");
            sb.append("\tnorth: " + regionMap1.getNorth() + "-" + regionMap2.getNorth() + "=" + (regionMap1.getNorth() - regionMap2.getNorth())).append("\n");
        }
        if (!regionMap1.equalsResolution((Object)regionMap2)) {
            sb.append("\tResolution Delta X: " + regionMap1.getXres() + "-" + regionMap2.getXres() + "=" + (regionMap1.getXres() - regionMap2.getXres())).append("\n");
            sb.append("\tResolution Delta Y: " + regionMap1.getYres() + "-" + regionMap2.getYres() + "=" + (regionMap1.getYres() - regionMap2.getYres())).append("\n");
        }
        if (!regionMap1.equalsColsRows((Object)regionMap2)) {
            sb.append("\tCols Delta: " + regionMap1.getCols() + "-" + regionMap2.getCols() + "=" + (regionMap1.getCols() - regionMap2.getCols())).append("\n");
            sb.append("\tRows Delta: " + regionMap1.getRows() + "-" + regionMap2.getRows() + "=" + (regionMap1.getRows() - regionMap2.getRows())).append("\n");
        }
        if (this.doPixelTest) {
            int cols = regionMap1.getCols();
            int rows = regionMap1.getRows();
            double[] xRange = NumericsUtilities.range2Bins((double)0.0, (double)cols, (int)this.pTestPixelsBins);
            double[] yRange = NumericsUtilities.range2Bins((double)0.0, (double)rows, (int)this.pTestPixelsBins);
            sb.append("\nPIXEL ANALYSIS").append("\n");
            sb.append("================================").append("\n");
            int equalCount = 0;
            int nonEqualCount = 0;
            for (double y : yRange) {
                for (double x : xRange) {
                    if (!raster1.isContained((int)x, (int)y) || !raster2.isContained((int)x, (int)y)) continue;
                    RasterCellInfo ri = new RasterCellInfo((int)x, (int)y, new GridCoverage2D[]{raster1.buildCoverage(), raster2.buildCoverage()});
                    ri.setBufferCells(2);
                    if (ri.allEqual() || raster1.isNovalue(ri.getValues()[0]) && raster2.isNovalue(ri.getValues()[1])) {
                        ++equalCount;
                        continue;
                    }
                    sb.append("VALUES IN ROW/COL = " + y + "/" + x + ":\n");
                    sb.append(ri.toString()).append("\n");
                    ++nonEqualCount;
                }
            }
            sb.append("===========================================\n");
            sb.append("EQUAL PIXELS FOUND IN TEST: " + equalCount).append("\n");
            sb.append("NONEQUAL PIXELS FOUND IN TEST: " + nonEqualCount).append("\n");
        }
        this.pm.message(sb.toString());
    }
}

