/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rasternull.OmsRasterMissingValuesFiller;

@Description(value="Modules that fills missing values in a raster by interpolation of border values.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Null, Missing values, Raster")
@Label(value="Raster Processing")
@Name(value="rmissingfiller")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterMissingValuesFiller
extends HMModel {
    @Description(value="The raster in which to fill missing values.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="An optional raster mask on which to fill missing data.")
    @UI(value="infile_raster")
    @In
    public String inMask;
    @Description(value="The min distance to consider for the interpolation (in cells).")
    @In
    public int pMinDistance = 0;
    @Description(value="The max distance to consider for the interpolation (in cells).")
    @In
    public int pMaxDistance = 10;
    @Description(value="Use only border values to interpolate (as opposed to all in the min.max range).")
    @In
    public boolean doUseOnlyBorderValues = false;
    @Description(value="Interpolation mode.")
    @UI(value="combo:IDW,LDW,TPS,AVERAGING,CATEGORIES")
    @In
    public String pMode = "IDW";
    @Description(value="The new raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterMissingValuesFiller ormvf = new OmsRasterMissingValuesFiller();
        ormvf.pm = this.pm;
        ormvf.inRaster = this.getRaster(this.inRaster);
        ormvf.inMask = this.getRaster(this.inMask);
        ormvf.pMinDistance = this.pMinDistance;
        ormvf.pMaxDistance = this.pMaxDistance;
        ormvf.doUseOnlyBorderValues = this.doUseOnlyBorderValues;
        ormvf.pMode = this.pMode;
        ormvf.process();
        this.dumpRaster(ormvf.outRaster, this.outRaster);
    }

    public static void main(String[] args) throws Exception {
        RasterMissingValuesFiller r = new RasterMissingValuesFiller();
        r.inRaster = "/home/hydrologis/TMP/KLAB/MANGROVE_INTERPOLATION/senegal_agb_moved.tif";
        r.inMask = "/home/hydrologis/TMP/KLAB/MANGROVE_INTERPOLATION/Global_Mangrove_Watch_2010_30m_4326_v2.tif";
        r.outRaster = "/home/hydrologis/TMP/KLAB/MANGROVE_INTERPOLATION/interpolated.tif";
        r.pMinDistance = 4;
        r.pMaxDistance = 10;
        r.doUseOnlyBorderValues = false;
        r.pMode = "LDW";
        r.process();
    }
}

