/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.subsampling.OmsRasterSubsampler;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Raster subsampler module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Subsampling")
@Label(value="Raster Processing")
@Name(value="rastersubsampler")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterSubsampler
extends HMModel {
    @Description(value="The raster to process.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The subsampling factor (default is 2).")
    @In
    public int pFactor = 2;
    @Description(value="The output raster map.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsRasterSubsampler ss = new OmsRasterSubsampler();
        ss.inRaster = this.getRaster(this.inRaster);
        ss.pFactor = this.pFactor;
        ss.process();
        this.dumpRaster(ss.outRaster, this.outRaster);
    }
}

