/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.transitionclasses.OmsRasterTransitionClasses;
import org.hortonmachine.gears.utils.files.FileUtilities;

@Description(value="Raster transition classes generator.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Classes, Transition")
@Label(value="Raster Processing")
@Name(value="rtransclasses")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterTransitionClasses
extends HMModel {
    @Description(value="The previous classes raster.")
    @UI(value="infile_raster")
    @In
    public String inPreviousRaster;
    @Description(value="The next classes raster.")
    @UI(value="infile_raster")
    @In
    public String inNextRaster;
    @Description(value="The output transitions raster.")
    @UI(value="outfile")
    @In
    public String outRaster;
    @Description(value="The output csv file of transition classes")
    @UI(value="outfile")
    @In
    public String outTransition;

    @Execute
    public void process() throws Exception {
        OmsRasterTransitionClasses r = new OmsRasterTransitionClasses();
        r.inPreviousRaster = this.getRaster(this.inPreviousRaster);
        r.inNextRaster = this.getRaster(this.inNextRaster);
        r.process();
        this.dumpRaster(r.outRaster, this.outRaster);
        StringBuilder sb = new StringBuilder();
        sb.append("crossclasscode; fromclass; toclass; count\n");
        Map<Integer, String> newClasses2KeyMap = r.key2NewClassesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (Map.Entry entry : r.newClasses2CountMap.entrySet()) {
            Integer newClass = (Integer)entry.getKey();
            Integer count = (Integer)entry.getValue();
            String transitionStr = newClasses2KeyMap.get(newClass);
            String[] split = transitionStr.split(" ");
            String from = split[0];
            String to = split[1];
            sb.append(newClass).append(";").append(from).append(";").append(to).append(";").append(count).append("\n");
        }
        if (this.outTransition != null) {
            FileUtilities.writeFile((String)sb.toString(), (File)new File(this.outTransition));
        }
    }
}

