/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules.docker;

import java.io.File;
import java.io.IOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.modules.docker.DockerHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class PdalDockerModel
extends HMModel {
    private static final String TAG = "latest";
    private static final String PDAL = "pdal/pdal";
    private static final String PDAL_WITHTAG = "pdal/pdal:latest";
    protected DockerHandler dockerHandler = new DockerHandler();

    protected void startContainer(String volumePath) throws Exception {
        this.dockerHandler.startContainer(PDAL_WITHTAG, volumePath);
    }

    protected String checkDockerInstall() {
        String error = this.dockerHandler.initDocker();
        if (error != null) {
            return error;
        }
        return null;
    }

    protected String hasImage() {
        return this.dockerHandler.hasImage(PDAL_WITHTAG);
    }

    protected void pullImage(IHMProgressMonitor pm) throws Exception {
        this.dockerHandler.pullImage(PDAL, TAG, pm);
    }

    protected void removeImage(String id) {
        this.dockerHandler.removeImage(id);
    }

    public void execCommand(String command) throws Exception {
        this.dockerHandler.execCommand(command);
    }

    public void closeClient() throws Exception {
        this.dockerHandler.closeClient();
    }

    public File getPipelineFile(File workspaceFile, String filterJson) throws IOException {
        File pipeLineFile = new File(workspaceFile, "pipeline.json");
        FileUtilities.writeFile((String)filterJson, (File)pipeLineFile);
        return pipeLineFile;
    }

    public String getPipelineJson(String inName, String outName, JSONObject ... filters) {
        JSONObject root = new JSONObject();
        JSONArray pipelineArray = new JSONArray();
        root.put("pipeline", (Object)pipelineArray);
        JSONObject reader = new JSONObject();
        reader.put("type", (Object)"readers.las");
        reader.put("filename", (Object)inName);
        pipelineArray.put((Object)reader);
        for (JSONObject filter : filters) {
            pipelineArray.put((Object)filter);
        }
        JSONObject writer = new JSONObject();
        writer.put("type", (Object)"writers.las");
        writer.put("minor_version", 1);
        writer.put("filename", (Object)outName);
        pipelineArray.put((Object)writer);
        String filterJson = root.toString(2);
        return filterJson;
    }
}

