/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorconverter.OmsDwgConverter;

@Description(value="Module to convert dxf files to geotools vecotors.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, OmsDxfConverter, Feature, Vector, Reading")
@Label(value="Vector Processing")
@Name(value="_dwgimport")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class DwgConverter
extends HMModel {
    @Description(value="The dwg input file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The output point vector.")
    @UI(value="outfile")
    @In
    public String pointsVector = null;
    @Description(value="The output line vector.")
    @UI(value="outfile")
    @In
    public String lineVector = null;
    @Description(value="The output polygon vector.")
    @UI(value="outfile")
    @In
    public String polygonVector = null;
    @Description(value="The output text vector.")
    @UI(value="outfile")
    @In
    public String textVector;
    @Description(value="The output attributes vector.")
    @UI(value="outfile")
    @In
    public String attributesVector;
    @Description(value="The output contour vector.")
    @UI(value="outfile")
    @In
    public String contourVector;

    @Execute
    public void readFeatureCollection() throws Exception {
        OmsDwgConverter dwgconverter = new OmsDwgConverter();
        dwgconverter.file = this.file;
        dwgconverter.pCode = this.pCode;
        dwgconverter.pm = this.pm;
        dwgconverter.doProcess = this.doProcess;
        dwgconverter.doReset = this.doReset;
        dwgconverter.readFeatureCollection();
        this.dumpVector(dwgconverter.pointsVector, this.pointsVector);
        this.dumpVector(dwgconverter.lineVector, this.lineVector);
        this.dumpVector(dwgconverter.polygonVector, this.polygonVector);
        this.dumpVector(dwgconverter.textVector, this.textVector);
        this.dumpVector(dwgconverter.attributesVector, this.attributesVector);
        this.dumpVector(dwgconverter.contourVector, this.contourVector);
    }
}

