/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Initialize;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.netcdf.INetcdfUtils;
import org.hortonmachine.gears.io.remotesensing.OmsModisDownloader;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.locationtech.jts.geom.Envelope;

@Description(value="Download MODIS data and patch dem together to coverages.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="modis")
@Label(value="NetCDF")
@Name(value="omsmodisdownloader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class ModisDownloader
extends HMModel
implements INetcdfUtils {
    @Description(value="In case of no grid name, an inclusion pattern can be used.")
    @In
    public String pIncludePattern = null;
    @Description(value="In case of no grid name, an exclusion pattern can be used.")
    @In
    public String pExcludePattern = null;
    @Description(value="A folder in which to download the tiles to be patched.")
    @UI(value="infolder")
    @In
    public String pIntermediateDownloadFolder = null;
    @Description(value="The download day in format YYYY-MM-DD.")
    @In
    public String pDay = null;
    @Description(value="The count of days to download before the selected pDay.")
    @In
    public int pDelta = 0;
    @Description(value="The url to download the data from.")
    @In
    public String pDownloadUrl = "https://e4ftl01.cr.usgs.gov";
    @Description(value="The user registered to the modis website.")
    @In
    public String pUser = null;
    @Description(value="The user registered to the modis website.")
    @In
    public String pPassword;
    @Description(value="The url path defining the type of product.")
    @UI(value="combo:MOLA,MOLT,MOTA")
    @In
    public String pProductPath = "MOTA";
    @Description(value="The url part defining the product.")
    @In
    public String pProduct = null;
    @Description(value="The data version.")
    @In
    public String pVersion = "006";
    @Description(value="The region of interest as [w,e,s,n]")
    @In
    public double[] pRoi = null;
    @Description(value="Convert the downloaded hdf to geotiff.")
    @In
    public boolean doGeotiffs = true;
    @Description(value="Do the Mosaic and clip over the region of interest.")
    @In
    public boolean doMosaicAndClip = true;
    @Description(value="The output folder in which to place the final result.")
    @UI(value="outfolder")
    @In
    public String outFolder;

    @Initialize
    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.pDownloadUrl, this.pProductPath, this.pProduct, this.pVersion, this.pRoi, this.pUser, this.pPassword, this.outFolder});
        String daysListUrl = this.pDownloadUrl + "/" + this.pProductPath + "/" + this.pProduct + "." + this.pVersion;
        String daysListPage = OmsModisDownloader.getWebpageString((String)daysListUrl);
        String[] linesSplit = daysListPage.split("img src=");
        ArrayList<String> datesList = new ArrayList<String>();
        for (String line : linesSplit) {
            if (!line.contains("\"/icons/folder.gif")) continue;
            String tmp = line.split("<a href=.{13}>")[1];
            String dateString = tmp.split("/</a>")[0];
            datesList.add(dateString);
        }
        if (datesList.size() == 0) {
            throw new ModelsIOException("Could not retrieve the available dates at " + daysListUrl, (Object)this);
        }
        Collections.sort(datesList);
        this.pDay = this.pDay.replace("-", ".");
        int todayIndex = datesList.indexOf(this.pDay);
        if (todayIndex < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("The asked date is not available: " + this.pDay + "\n");
            SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
            Date pDayDate = f.parse(this.pDay);
            this.pDay = null;
            long dayDateMillis = pDayDate.getTime();
            for (int i = 1; i < datesList.size(); ++i) {
                int daysDiff;
                String pre = (String)datesList.get(i - 1);
                String post = (String)datesList.get(i);
                Date preDate = f.parse(pre);
                Date postDate = f.parse(post);
                if (dayDateMillis <= preDate.getTime() || dayDateMillis >= postDate.getTime() || (daysDiff = (int)Math.round((double)((postDate.getTime() - pDayDate.getTime()) / 1000L / 60L / 60L) / 24.0)) >= 7) continue;
                this.pDay = f.format(postDate);
                todayIndex = i;
                break;
            }
            if (this.pDay == null) {
                sb.append("Unable to retrieve a valid nearby date.");
                this.pm.errorMessage(sb.toString());
                return;
            }
            sb.append("Using the nearest found date instead: " + this.pDay);
            this.pm.errorMessage(sb.toString());
        }
        ArrayList<String> daysToDownload = new ArrayList<String>();
        for (int i = todayIndex - this.pDelta; i <= todayIndex; ++i) {
            daysToDownload.add((String)datesList.get(i));
        }
        this.pm.message("Downloading data of the following days (" + daysToDownload.size() + "):");
        for (String day : daysToDownload) {
            this.pm.message("\t" + day);
        }
        for (String day : daysToDownload) {
            OmsModisDownloader md = new OmsModisDownloader();
            md.pm = this.pm;
            md.pRoi = new Envelope(this.pRoi[0], this.pRoi[1], this.pRoi[2], this.pRoi[3]);
            md.pProductPath = this.pProductPath;
            md.pProduct = this.pProduct;
            md.pVersion = this.pVersion;
            md.pDay = day;
            md.pIncludePattern = this.pIncludePattern;
            md.pExcludePattern = this.pExcludePattern;
            md.pUser = this.pUser;
            md.pPassword = this.pPassword;
            md.pIntermediateDownloadFolder = this.pIntermediateDownloadFolder;
            md.doGeotiffs = this.doGeotiffs;
            md.doMosaicAndClip = this.doMosaicAndClip;
            md.process();
            if (!this.doMosaicAndClip || md.outRaster == null) continue;
            GridCoverage2D finalRaster = md.outRaster;
            String gridName = finalRaster.getName().toString();
            gridName = FileUtilities.getSafeFileName((String)gridName);
            File folder = new File(this.outFolder);
            File dayFolderFile = new File(folder, this.pProductPath + "_" + this.pProduct + "_" + this.pVersion + File.separator + day);
            if (!dayFolderFile.exists()) {
                dayFolderFile.mkdirs();
            }
            File file = new File(dayFolderFile, gridName + ".tif");
            this.dumpRaster(finalRaster, file.getAbsolutePath());
        }
    }
}

