/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.hmachine.modules.network.netnumbering.OmsNetNumbering;

@Description(value="Assigns the numbers to the network's links.")
@Author(name="Antonello Andrea, Franceschi Silvia, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Network, SplitSubbasins")
@Label(value="HortonMachine/Network")
@Name(value="_netnum")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class NetNumbering
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of total contributing area.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The map of the network.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The monitoringpoints vector map.")
    @UI(value="infile_vector")
    @In
    public String inPoints = null;
    @Description(value="The desired basins area size.")
    @Unit(value="m2")
    @In
    public Double pDesiredArea = null;
    @Description(value="The allowed variance for the desired area.")
    @Unit(value="%")
    @In
    public Double pDesiredAreaDelta = null;
    @Description(value="The map of netnumbering")
    @UI(value="outfile")
    @In
    public String outNetnum = null;
    @Description(value="The map of subbasins")
    @UI(value="outfile")
    @In
    public String outBasins = null;
    @Description(value="The map of desired size subbasins")
    @UI(value="outfile")
    @In
    public String outDesiredBasins = null;
    @Description(value="Output mindmap (plantuml).")
    @UI(value="outfile")
    @In
    public String outMindmap = null;
    @Description(value="Output desired mindmap (plantuml).")
    @UI(value="outfile")
    @In
    public String outDesiredMindmap = null;
    @Description(value="The optional geoframe topology output file.")
    @UI(value="outfile")
    @In
    public String outGeoframeTopology = null;
    @Description(value="The optional basins info output file.")
    @UI(value="outfile")
    @In
    public String outBasinsInfo = null;

    @Execute
    public void process() throws Exception {
        OmsNetNumbering omsnetnumbering = new OmsNetNumbering();
        omsnetnumbering.inFlow = this.getRaster(this.inFlow);
        omsnetnumbering.inTca = this.getRaster(this.inTca);
        omsnetnumbering.inNet = this.getRaster(this.inNet);
        omsnetnumbering.inPoints = this.getVector(this.inPoints);
        omsnetnumbering.pDesiredArea = this.pDesiredArea;
        omsnetnumbering.pDesiredAreaDelta = this.pDesiredAreaDelta;
        omsnetnumbering.outMindmap = this.outMindmap;
        omsnetnumbering.doProcess = this.doProcess;
        omsnetnumbering.doReset = this.doReset;
        omsnetnumbering.process();
        this.dumpRaster(omsnetnumbering.outNetnum, this.outNetnum);
        this.dumpRaster(omsnetnumbering.outBasins, this.outBasins);
        this.dumpRaster(omsnetnumbering.outDesiredBasins, this.outDesiredBasins);
        if (this.outMindmap != null && this.outMindmap.trim().length() > 0) {
            FileUtilities.writeFile((String)omsnetnumbering.outMindmap, (File)new File(this.outMindmap));
        }
        if (this.pDesiredArea != null && this.outDesiredMindmap != null && this.outDesiredMindmap.trim().length() > 0) {
            FileUtilities.writeFile((String)omsnetnumbering.outDesiredMindmap, (File)new File(this.outDesiredMindmap));
        }
        if (this.outGeoframeTopology != null && omsnetnumbering.outGeoframeTopology != null && omsnetnumbering.outGeoframeTopology.trim().length() > 0) {
            FileUtilities.writeFile((String)omsnetnumbering.outGeoframeTopology, (File)new File(this.outGeoframeTopology));
        }
        if (this.outBasinsInfo != null && omsnetnumbering.outBasinsInfo != null && omsnetnumbering.outBasinsInfo.trim().length() > 0) {
            FileUtilities.writeFile((String)omsnetnumbering.outBasinsInfo, (File)new File(this.outBasinsInfo));
        }
    }

    public static void main(String[] args) throws Exception {
        String folder = "/Users/hydrologis/Dropbox/hydrologis/lavori/2020_projects/15_uniTN_basins/brenta/brenta_063basins_5M_20/";
        Object inPoints = null;
        Double desiredArea = 5000000.0;
        Double desiredDelta = 20.0;
        String inFlow = folder + "brenta_drain.asc";
        String inTca = folder + "brenta_tca.asc";
        String inNet = folder + "brenta_net_10000.asc";
        String withPoints = inPoints == null ? "" : "_pts";
        String outNetnum = folder + "mytest" + withPoints + "_netnum.asc";
        String outBasins = folder + "mytest" + withPoints + "_basins.asc";
        Object extra = "";
        if (desiredArea != null) {
            extra = "_desiredbasins_" + desiredArea + "_" + desiredDelta;
        }
        String outDesireredBasins = folder + "mytest" + withPoints + (String)extra + ".asc";
        String outMM = folder + "mytest" + withPoints + "_mindmap.txt";
        String outDesMM = folder + "mytest" + withPoints + "_mindmap" + (String)extra + ".txt";
        String outGeoframe = folder + "mytest" + withPoints + "_geoframe.txt";
        String outBasinInfo = folder + "mytest" + withPoints + "_basininfo.txt";
        NetNumbering omsnetnumbering = new NetNumbering();
        omsnetnumbering.inFlow = inFlow;
        omsnetnumbering.inTca = inTca;
        omsnetnumbering.inNet = inNet;
        omsnetnumbering.pDesiredArea = desiredArea;
        omsnetnumbering.pDesiredAreaDelta = desiredDelta;
        if (inPoints != null) {
            omsnetnumbering.inPoints = inPoints;
        }
        omsnetnumbering.outMindmap = outMM;
        omsnetnumbering.outDesiredMindmap = outDesMM;
        omsnetnumbering.outGeoframeTopology = outGeoframe;
        omsnetnumbering.outBasinsInfo = outBasinInfo;
        omsnetnumbering.outBasins = outBasins;
        omsnetnumbering.outDesiredBasins = outDesireredBasins;
        omsnetnumbering.outNetnum = outNetnum;
        omsnetnumbering.process();
    }
}

