/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONObject;

@Description(value="PDAL filter.range command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="pdal, filter, range, docker")
@Label(value="Pdal")
@Name(value="_pdal_filter_range")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class PdalFilterRange
extends PdalDockerModel {
    @Description(value="The pdal file to filter.")
    @UI(value="infile_las")
    @In
    public String inPath = null;
    @Description(value="The output file name.")
    @In
    public String outName = null;
    @Description(value="An min classification value.")
    @In
    public Integer pMinClassification = 7;
    @Description(value="An max classification value.")
    @In
    public Integer pMaxClassification = 7;
    @Description(value="Negate classification filter")
    @In
    public boolean doNegateClassification = false;
    @Description(value="An min Z value.")
    @In
    public Double pMinZ;
    @Description(value="An max Z value.")
    @In
    public Double pMaxZ;
    @Description(value="Negate Z filter")
    @In
    public boolean doNegateZ = false;
    @Description(value="Additional ranges. The format is ex. Red[1:50], Blue[25:75], Red[75:255], Intensity![25:25]")
    @In
    public String pAdditionalRanges;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inPath});
        String error = this.checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(this.inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();
                JSONObject filter = new JSONObject();
                filter.put("type", (Object)"filters.range");
                Object rangeStr = "";
                if (this.pMinClassification != null) {
                    rangeStr = (String)rangeStr + "Classification" + (this.doNegateClassification ? "!" : "") + "[" + this.pMinClassification + ":";
                    if (this.pMaxClassification != null) {
                        rangeStr = (String)rangeStr + this.pMaxClassification;
                    }
                    rangeStr = (String)rangeStr + "]";
                }
                if (this.pMinZ != null) {
                    if (((String)rangeStr).length() > 0) {
                        rangeStr = (String)rangeStr + ", ";
                    }
                    rangeStr = (String)rangeStr + "Z" + (this.doNegateZ ? "!" : "") + "[" + this.pMinZ + ":";
                    if (this.pMaxZ != null) {
                        rangeStr = (String)rangeStr + this.pMaxZ;
                    }
                    rangeStr = (String)rangeStr + "]";
                }
                if (this.pAdditionalRanges != null) {
                    if (((String)rangeStr).length() > 0) {
                        rangeStr = (String)rangeStr + ", ";
                    }
                    rangeStr = (String)rangeStr + this.pAdditionalRanges;
                }
                filter.put("limits", rangeStr);
                String pipelineJson = this.getPipelineJson(inName, this.outName, filter);
                this.pm.message("Running pipeline with filter:");
                this.pm.message(pipelineJson);
                File pipelineFile = this.getPipelineFile(workspaceFile, pipelineJson);
                String cmd = "pdal pipeline " + pipelineFile.getName();
                this.startContainer(workspace);
                this.pm.beginTask("Running command...", -1);
                this.execCommand(cmd);
                this.pm.done();
                pipelineFile.delete();
            }
            finally {
                this.closeClient();
            }
        } else {
            this.pm.errorMessage(error);
        }
    }

    public static void main(String[] args) throws Exception {
        PdalFilterRange i = new PdalFilterRange();
        i.inPath = "/Users/hydrologis/data/las/EXAMPLE_river.las";
        i.pMinClassification = 6;
        i.pMaxClassification = 7;
        i.pAdditionalRanges = "Classification[2:2]";
        i.outName = "filtered.las";
        i.process();
    }
}

