/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.lesto.modules.vegetation.rastermaxima.OmsRasterMaximaFinder;

@Description(value="Module to find local maxima.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Raster, Maxima")
@Label(value="Lesto/vegetation")
@Name(value="rastermaximafinder")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class RasterMaximaFinder
extends HMModel {
    @Description(value="The input CHM.")
    @UI(value="infile_raster")
    @In
    public String inDsmDtmDiff;
    @Description(value="Processing mode.")
    @UI(value="combo:custom,mixed_pines_and_deciduous_trees,deciduous,conifer")
    @In
    public String pMode = "custom";
    @Description(value="Threshold on maxima. Only maxima higher than the threshold are kept.")
    @In
    public double pThreshold = 1.0;
    @Description(value="The windows size in cells to use for custom mode(default is 3).")
    @In
    public int pSize = 3;
    @Description(value="Percentage to apply to the maxima window to downsize it (default is 60%). This is ignored in CUSTOM mode.")
    @In
    public int pPercent = 60;
    @Description(value="Maximum radius to use in meters. This is ignored in CUSTOM mode.")
    @In
    public double pMaxRadius = 3.0;
    @Description(value="Use circular window.")
    @In
    public boolean doCircular = true;
    @Description(value="Allow novalues inside the window of the maxima.")
    @In
    public boolean doAllowNovalues = false;
    @Description(value="Distance threshold to mark maxima as near a border. If <0 check is ignored.")
    @Unit(value="m")
    @In
    public double pBorderDistanceThres = -1.0;
    @Description(value="Top buffer threshold")
    @Unit(value="m")
    @In
    public double pTopBufferThres = 5.0;
    @Description(value="Top buffer threshold cell count")
    @In
    public int pTopBufferThresCellCount = 2;
    @Description(value="The maxima vector.")
    @UI(value="outfile")
    @In
    public String outMaxima;
    @Description(value="The maxima related areas vector.")
    @UI(value="outfile")
    @In
    public String outCircles;

    @Execute
    public void process() throws Exception {
        OmsRasterMaximaFinder maxFinder = new OmsRasterMaximaFinder();
        maxFinder.inDsmDtmDiff = this.getRaster(this.inDsmDtmDiff);
        maxFinder.pMode = this.pMode;
        maxFinder.pThreshold = this.pThreshold;
        maxFinder.pSize = this.pSize;
        maxFinder.pPercent = this.pPercent;
        maxFinder.pMaxRadius = this.pMaxRadius;
        maxFinder.doCircular = this.doCircular;
        maxFinder.doAllowNovalues = this.doAllowNovalues;
        maxFinder.pBorderDistanceThres = this.pBorderDistanceThres;
        maxFinder.pTopBufferThres = this.pTopBufferThres;
        maxFinder.pTopBufferThresCellCount = this.pTopBufferThresCellCount;
        maxFinder.process();
        this.dumpVector(maxFinder.outMaxima, this.outMaxima);
        this.dumpVector(maxFinder.outCircles, this.outCircles);
    }
}

