/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorfieldrounder.OmsVectorFieldRounder;

@Description(value="Module that rounds a defined field attribute.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Round, VectorFieldJoiner")
@Label(value="Vector Processing")
@Name(value="_vround")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorFieldRounder
extends HMModel {
    @Description(value="The vector of which to round a numeric value.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The double field of the number to round.")
    @In
    public String fRound = null;
    @Description(value="The rounding pattern.")
    @In
    public String pPattern = null;
    @Description(value="The modified vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsVectorFieldRounder vectorfieldrounder = new OmsVectorFieldRounder();
        vectorfieldrounder.inVector = this.getVector(this.inVector);
        vectorfieldrounder.fRound = this.fRound;
        vectorfieldrounder.pPattern = this.pPattern;
        vectorfieldrounder.pm = this.pm;
        vectorfieldrounder.doProcess = this.doProcess;
        vectorfieldrounder.doReset = this.doReset;
        vectorfieldrounder.process();
        this.dumpVector(vectorfieldrounder.outVector, this.outVector);
    }
}

