/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Vectors features writer to file module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Writing")
@Label(value="Vector Writer")
@Name(value="_vectorwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorWriter
extends HMModel {
    @Description(value="The read feature collection.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The vector type to write (Supported is: shp).")
    @In
    public String pType = null;
    @Description(value="The vector file to write.")
    @UI(value="outfile")
    @In
    public String file = null;

    @Execute
    public void process() throws Exception {
        OmsVectorWriter vectorwriter = new OmsVectorWriter();
        vectorwriter.inVector = this.inVector;
        vectorwriter.pType = this.pType;
        vectorwriter.file = this.file;
        vectorwriter.pm = this.pm;
        vectorwriter.doProcess = this.doProcess;
        vectorwriter.doReset = this.doReset;
        vectorwriter.process();
    }

    public static void writeVector(String path, SimpleFeatureCollection featureCollection) throws Exception {
        OmsVectorWriter.writeVector((String)path, (SimpleFeatureCollection)featureCollection);
    }
}

