/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.viewshed.OmsViewshed;

@Description(value="Viewshed module")
@Documentation(value="Calculate a viewshed raster, with values based on the visibility by the supplied view points.")
@Author(name="Dr. John Lindsay", contact="jlindsay@uoguelph.ca")
@Keywords(value="viewshed")
@Label(value="HortonMachine/Geomorphology")
@Name(value="viewshed")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Viewshed
extends HMModel {
    @Description(value="Input elevation raster.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="Input viewpoints collection.")
    @UI(value="infile_vector")
    @In
    public String inViewPoints = null;
    @Description(value="Name of the field containing the station's height above the elevation model")
    @In
    public String pField = "elev";
    @Description(value="Default height above the elevation model to use if no station's height field is available.")
    @Unit(value="m")
    @In
    public double pHeight = 2.0;
    @Description(value="Output viewshed raster.")
    @UI(value="outfile")
    @In
    public String outViewshed = null;

    @Execute
    public void process() throws Exception {
        OmsViewshed vs = new OmsViewshed();
        vs.pm = this.pm;
        vs.inRaster = this.getRaster(this.inRaster);
        vs.inViewPoints = this.getVector(this.inViewPoints);
        vs.pField = this.pField;
        vs.pHeight = this.pHeight;
        vs.process();
        this.dumpRaster(vs.outViewshed, this.outViewshed);
    }
}

