/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.interpolation2d.OmsSurfaceInterpolator;

@Description(value="Thin Plate Spline and IWD Interpolators")
@Author(name="Jan Jezek, Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Interpolation, Raster, Spline")
@Label(value="Raster Processing")
@Name(value="_surfaceinterpolator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class SurfaceInterpolator
extends HMModel {
    @Description(value="The input vector map of points.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The grid on which to interpolate.")
    @UI(value="infile_raster")
    @In
    public String inGrid;
    @Description(value="A mask raster map. Values will be computed only where the mask has values.")
    @UI(value="infile_raster")
    @In
    public String inMask = null;
    @Description(value="Field from which to take the category value.")
    @In
    public String fCat;
    @Description(value="Interpolation mode.")
    @UI(value="combo:TPS,IDW")
    @In
    public String pMode = "TPS";
    @Description(value="The buffer to use for interpolation.")
    @Unit(value="m")
    @In
    public double pBuffer = 4.0;
    @Description(value="Max threads to use.")
    @In
    public int pMaxThreads = 1;
    @Description(value="The interpolated raster")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsSurfaceInterpolator surfaceinterpolator = new OmsSurfaceInterpolator();
        surfaceinterpolator.inVector = this.getVector(this.inVector);
        surfaceinterpolator.inGrid = this.getRaster(this.inGrid);
        surfaceinterpolator.inMask = this.getRaster(this.inMask);
        surfaceinterpolator.fCat = this.fCat;
        surfaceinterpolator.pMode = this.pMode;
        surfaceinterpolator.pBuffer = this.pBuffer;
        surfaceinterpolator.pMaxThreads = this.pMaxThreads;
        surfaceinterpolator.pm = this.pm;
        surfaceinterpolator.doProcess = this.doProcess;
        surfaceinterpolator.doReset = this.doReset;
        surfaceinterpolator.process();
        this.dumpRaster(surfaceinterpolator.outRaster, this.outRaster);
    }
}

