/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorclipper.OmsVectorClipper;

@Description(value="A vector clipping module.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, Clip, Vector")
@Label(value="Vector Processing")
@Name(value="_clipper")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class VectorClipper
extends HMModel {
    @Description(value="The vector map to be clipped.")
    @UI(value="infile_vector")
    @In
    public String inMap = null;
    @Description(value="The clipping vector map.")
    @UI(value="infile_vector")
    @In
    public String inClipper = null;
    @Description(value="Max threads to use (default 1)")
    @In
    public int pMaxThreads = 1;
    @Description(value="The resulting vector map.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsVectorClipper vectorclipper = new OmsVectorClipper();
        vectorclipper.inMap = this.getVector(this.inMap);
        vectorclipper.inClipper = this.getVector(this.inClipper);
        vectorclipper.pMaxThreads = this.pMaxThreads;
        vectorclipper.pm = this.pm;
        vectorclipper.doProcess = this.doProcess;
        vectorclipper.doReset = this.doReset;
        vectorclipper.process();
        this.dumpVector(vectorclipper.outMap, this.outMap);
    }
}

