/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.modules.docker.GdalDockerModel;

@Description(value="GdalInfo command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="gdal, docker")
@Label(value="Gdal")
@Name(value="_gdalinfo")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GdalInfo
extends GdalDockerModel {
    @Description(value="The gdal file to check.")
    @UI(value="infile")
    @In
    public String inPath = null;
    @Description(value="Show the supported formats and exit.")
    @In
    public boolean doShowFormats = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        try {
            if (this.doShowFormats || this.inPath == null) {
                String cmd = "gdalinfo --formats";
                this.startContainer(null);
                this.execCommand(cmd);
            } else {
                this.checkFileExists(new String[]{this.inPath});
                File file = new File(this.inPath);
                String workspace = file.getParentFile().getAbsolutePath();
                String cmd = "gdalinfo " + file.getName();
                this.startContainer(workspace);
                this.execCommand(cmd);
            }
        }
        finally {
            this.closeClient();
        }
    }

    public static void main(String[] args) throws Exception {
        GdalInfo i = new GdalInfo();
        i.inPath = "/Users/hydrologis/data/DTM_calvello/aspect.asc";
        i.doShowFormats = false;
        i.process();
    }
}

