/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.modules.docker.GdalDockerModel;

@Description(value="Gdal geopackage tiles creation command.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="gdal, docker, geopackage")
@Label(value="Gdal")
@Name(value="_gdalgeopackagecreator")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class GdalTilesGeopackageCreator
extends GdalDockerModel {
    @Description(value="The raster file to convert.")
    @UI(value="infile_raster")
    @In
    public String inRaster = null;
    @Description(value="The name of the geopackage (if null, the name of the raster is used).")
    @In
    public String inName = null;
    @Description(value="The name of the new table to create (if null, the geopackage name is used).")
    @In
    public String inTable = null;
    @Description(value="Create also lower zoomlevel.")
    @In
    public boolean doLowerZoomLevels = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        try {
            this.checkNull(new Object[]{this.inRaster});
            this.checkFileExists(new String[]{this.inRaster});
            File file = new File(this.inRaster);
            if (this.inName == null) {
                this.inName = FileUtilities.getNameWithoutExtention((File)file);
            }
            if (this.inTable == null) {
                this.inTable = this.inName;
            }
            if (!this.inName.endsWith("gpkg")) {
                this.inName = this.inName + ".gpkg";
            }
            String workspace = file.getParentFile().getAbsolutePath();
            String cmd = "gdal_translate -of GPKG " + file.getName() + " " + this.inName + " -co  APPEND_SUBDATASET=YES -co RASTER_TABLE=" + this.inTable + " -co TILING_SCHEME=GoogleMapsCompatible";
            this.pm.message(cmd);
            this.startContainer(workspace);
            this.execCommand(cmd);
            if (this.doLowerZoomLevels) {
                cmd = "gdaladdo -r cubic " + this.inName + " 2 4 8 16 32";
                this.pm.message(cmd);
                this.execCommand(cmd);
            }
        }
        finally {
            this.closeClient();
        }
    }

    public static void main(String[] args) throws Exception {
        GdalTilesGeopackageCreator i = new GdalTilesGeopackageCreator();
        i.inRaster = "/Users/hydrologis/data/geopackage/mebo2017.tiff";
        i.inName = "mebo_orthos.gpkg";
        i.inTable = "mebo2017";
        i.doLowerZoomLevels = true;
        i.process();
    }
}

