/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.hacklength.OmsHackLength;

@Description(value="Assigned a point in a basin calculates the distance from the watershed measured along the net (until it exists) and then, again from valley upriver, along the maximal slope.")
@Author(name="Antonello Andrea, Franceschi Silvia, Daniele Andreis,  Erica Ghesla, Cozzini Andrea,  Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com")
@Keywords(value="Network, HackLength3D, HackStream")
@Label(value="HortonMachine/Network")
@Name(value="_hacklength")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class HackLength
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of tca.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The optional map of the elevation to work in 3D mode.")
    @UI(value="infile_raster")
    @In
    public String inElevation = null;
    @Description(value="The map of hack lengths.")
    @UI(value="outfile")
    @In
    public String outHacklength = null;

    @Execute
    public void process() throws Exception {
        OmsHackLength hacklength = new OmsHackLength();
        hacklength.inFlow = this.getRaster(this.inFlow);
        hacklength.inTca = this.getRaster(this.inTca);
        hacklength.inElevation = this.getRaster(this.inElevation);
        hacklength.pm = this.pm;
        hacklength.doProcess = this.doProcess;
        hacklength.doReset = this.doReset;
        hacklength.process();
        this.dumpRaster(hacklength.outHacklength, this.outHacklength);
    }
}

