/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules.docker;

import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.modules.docker.DockerHandler;

public class GdalDockerModel
extends HMModel {
    private static final String TAG = "latest";
    private static final String OSGEO_GDAL = "osgeo/gdal";
    private static final String OSGEO_GDAL_WITHTAG = "osgeo/gdal:latest";
    protected DockerHandler dockerHandler = new DockerHandler();

    protected void startContainer(String volumePath) throws Exception {
        this.checkDockerInstall();
        this.dockerHandler.startContainer(OSGEO_GDAL, volumePath);
    }

    protected void checkDockerInstall() {
        if (!this.dockerHandler.initDocker()) {
            throw new ModelsRuntimeException("An error occurred with the docker instance. Is docker running on your machine?", (Object)this);
        }
    }

    protected String hasImage() {
        return this.dockerHandler.hasImage(OSGEO_GDAL_WITHTAG);
    }

    protected void pullImage(IHMProgressMonitor pm) throws Exception {
        this.dockerHandler.pullImage(OSGEO_GDAL, TAG, pm);
    }

    protected void removeImage(String id) {
        this.dockerHandler.removeImage(id);
    }

    public void execCommand(String command) throws Exception {
        this.dockerHandler.execCommand(command);
    }

    public void closeClient() throws Exception {
        this.dockerHandler.closeClient();
    }
}

