/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.cutout.OmsCutOut;

@Description(value="Module for raster thresholding and masking.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Threshold, OmsMapcalc")
@Label(value="Raster Processing")
@Name(value="_cutout")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class CutOut
extends HMModel {
    @Description(value="The map that has to be processed.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The map to use as mask.")
    @UI(value="infile_raster")
    @In
    public String inMask;
    @Description(value="The upper threshold value.")
    @In
    public Double pMax;
    @Description(value="The lower threshold value.")
    @In
    public Double pMin;
    @Description(value="Switch for doing extraction of the mask area or the inverse (negative). Default is false and extract the mask area.")
    @In
    public boolean doInverse = false;
    @Description(value="The processed map.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        OmsCutOut c = new OmsCutOut();
        c.pm = this.pm;
        c.inRaster = this.getRaster(this.inRaster);
        c.inMask = this.getRaster(this.inMask);
        c.pMax = this.pMax;
        c.pMin = this.pMin;
        c.doInverse = this.doInverse;
        c.process();
        this.dumpRaster(c.outRaster, this.outRaster);
    }
}

