/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.geopaparazzi.OmsGeopaparazzi4Converter;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Converts a geopaparazzi 4 project database into shapefiles.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="geopaparazzi, vector")
@Label(value="Mobile")
@Name(value="geopapconvert_v4")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Geopaparazzi4Converter
extends HMModel {
    @Description(value="The geopaparazzi database file (*.gpap).")
    @UI(value="infile_gpap")
    @In
    public String inGeopaparazzi = null;
    @Description(value="Flag to create notes")
    @In
    public boolean doNotes = true;
    @Description(value="Flag to create log lines")
    @In
    public boolean doLoglines = true;
    @Description(value="Flag to create log points")
    @In
    public boolean doLogpoints = false;
    @Description(value="Flag to create media points")
    @In
    public boolean doMedia = true;
    @Description(value="The output folder")
    @UI(value="outfolder")
    @In
    public String outData = null;

    @Execute
    public void process() throws Exception {
        OmsGeopaparazzi4Converter geopaparazziconverter = new OmsGeopaparazzi4Converter();
        geopaparazziconverter.inGeopaparazzi = this.inGeopaparazzi;
        geopaparazziconverter.doNotes = this.doNotes;
        geopaparazziconverter.doLoglines = this.doLoglines;
        geopaparazziconverter.doLogpoints = this.doLogpoints;
        geopaparazziconverter.doMedia = this.doMedia;
        geopaparazziconverter.outFolder = this.outData;
        geopaparazziconverter.pm = this.pm;
        geopaparazziconverter.process();
    }

    public static void main(String[] args) throws Exception {
        Geopaparazzi4Converter geopaparazziconverter = new Geopaparazzi4Converter();
        geopaparazziconverter.inGeopaparazzi = "/Users/hydrologis/Desktop/rilievo/smash_20200313_valfloriana.gpap";
        geopaparazziconverter.doNotes = true;
        geopaparazziconverter.doLoglines = true;
        geopaparazziconverter.doLogpoints = false;
        geopaparazziconverter.doMedia = true;
        geopaparazziconverter.outData = "/Users/hydrologis/Desktop/rilievo/output";
        geopaparazziconverter.process();
    }
}

