/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.rastervaluerounder.OmsRasterValueRounder;

@Description(value="Module that rounds the values of a raster map.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Round, Raster")
@Label(value="Raster Processing")
@Name(value="_rround")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterValueRounder
extends HMModel {
    @Description(value="The raster of which to round the values.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The rounding pattern.")
    @In
    public String pPattern = null;
    @Description(value="The rounded raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsRasterValueRounder rastervaluerounder = new OmsRasterValueRounder();
        rastervaluerounder.inRaster = this.getRaster(this.inRaster);
        rastervaluerounder.pPattern = this.pPattern;
        rastervaluerounder.pm = this.pm;
        rastervaluerounder.doProcess = this.doProcess;
        rastervaluerounder.doReset = this.doReset;
        rastervaluerounder.process();
        this.dumpRaster(rastervaluerounder.outRaster, this.outRaster);
    }
}

