/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.OutputStream;
import java.util.List;
import org.hortonmachine.dbs.utils.OsCheck;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.StringUtilities;
import org.joda.time.DateTime;

public class DockerHandler {
    public static final String WORKSPACE = "/workspace";
    private static final String MSG_NOTRUNNING = "An error occurred with the docker instance. Is docker running on your machine?";
    private static final String MSG_WIN_SOCKET = "If docker is running, make sure set \n\nExpose daemon on tcp://localhost:2375 without TLS\n\nin the docker General docker Settings.";
    public static final String[] keepAliveCmd = new String[]{"sh", "-c", "while :; do sleep 1; done"};
    private DockerClient dockerClient;
    private String containerId;

    public String hasImage(String imageName) {
        List images = (List)this.dockerClient.listImagesCmd().withImageNameFilter(imageName).exec();
        if (images.size() > 0) {
            return ((Image)images.get(0)).getId();
        }
        return null;
    }

    public void removeImage(String imageId) {
        this.dockerClient.removeImageCmd(imageId).exec();
    }

    public void pullImage(String imageName, String tag, final IHMProgressMonitor pm) throws Exception {
        PullImageResultCallback resultCallback = new PullImageResultCallback();
        if (pm != null) {
            resultCallback = new PullImageResultCallback(){

                public void onNext(PullResponseItem item) {
                    ResponseItem.ProgressDetail progressDetail;
                    String id = item.getId();
                    if (item != null && (progressDetail = item.getProgressDetail()) != null) {
                        Long currentObj = progressDetail.getCurrent();
                        Long totalObj = progressDetail.getTotal();
                        if (currentObj != null && totalObj != null) {
                            int current = (int)(currentObj / 1000L);
                            int total = (int)(totalObj / 1000L);
                            String totalUnit = "KB";
                            String currentUnit = "KB";
                            if (total > 1024) {
                                total /= 1000;
                                totalUnit = "MB";
                            }
                            if (current > 1024) {
                                current /= 1000;
                                currentUnit = "MB";
                            }
                            String msg = null;
                            msg = current == total ? "Finished downloading " + id : "Downloading " + id + " ( " + current + currentUnit + "/" + total + totalUnit + " )";
                            pm.message(msg);
                        }
                    }
                    super.onNext(item);
                }

                public void onError(Throwable throwable) {
                    pm.errorMessage("Failed to start pull command:" + throwable.getMessage());
                    super.onError(throwable);
                }
            };
        }
        this.dockerClient.pullImageCmd(imageName).withTag(tag).exec((ResultCallback)resultCallback);
        resultCallback.awaitCompletion();
    }

    public String initDocker() {
        try {
            DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
            if (OsCheck.getOperatingSystemType() == OsCheck.OSType.Windows) {
                builder.withDockerHost("tcp://localhost:2375");
            }
            this.dockerClient = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)builder).build();
            this.dockerClient.versionCmd().exec();
        }
        catch (Exception e) {
            String msg = MSG_NOTRUNNING;
            if (OsCheck.getOperatingSystemType() == OsCheck.OSType.Windows) {
                msg = msg + "\nIf docker is running, make sure set \n\nExpose daemon on tcp://localhost:2375 without TLS\n\nin the docker General docker Settings.";
            }
            return msg;
        }
        return null;
    }

    public void startContainer(String imageName, String volumePath) throws Exception {
        CreateContainerResponse container;
        if (this.hasImage(imageName) == null) {
            throw new ModelsRuntimeException("The image " + imageName + " could not be found your system. Please run the GdalInstaller command first.", (Object)this);
        }
        String ts = DateTime.now().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSScompact);
        String name = imageName.replace('/', '_').replace(':', '_');
        if (volumePath != null) {
            Volume v = new Volume(WORKSPACE);
            container = this.dockerClient.createContainerCmd(imageName).withCmd(keepAliveCmd).withName(name + ts).withWorkingDir(WORKSPACE).withBinds(new Bind[]{new Bind(volumePath, v)}).exec();
        } else {
            container = this.dockerClient.createContainerCmd(imageName).withCmd(keepAliveCmd).withName(name + ts).exec();
        }
        this.containerId = container.getId();
        this.dockerClient.startContainerCmd(this.containerId).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(this.containerId).exec();
        if (!inspectContainerResponse.getState().getRunning().booleanValue()) {
            throw new ModelsRuntimeException("Container not running.", (Object)this);
        }
    }

    public void execCommand(String command) throws Exception {
        String[] commandArray = StringUtilities.parseCommand((String)command);
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(this.containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(commandArray).withUser("root").exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
    }

    public void closeClient() throws Exception {
        try {
            if (this.containerId != null) {
                this.dockerClient.stopContainerCmd(this.containerId).withTimeout(Integer.valueOf(2)).exec();
                this.dockerClient.removeContainerCmd(this.containerId).exec();
            }
        }
        finally {
            this.dockerClient.close();
        }
    }
}

