/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.hillshade.OmsHillshade;

@Description(value="This class evalutate the hillshade of a DEM.")
@Author(name="Daniele Andreis and Riccardo Rigon", contact="http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Hydrology, Radiation, SkyviewFactor, OmsInsolation")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_hillshade")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Hillshade
extends HMModel {
    @Description(value="The map of the elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The minimum value of diffuse insolation between 0 to 1 (default is 0).")
    @In
    public double pMinDiffuse = 0.0;
    @Description(value="The value of the azimuth (default is 360).")
    @In
    public double pAzimuth = 360.0;
    @Description(value="The sun elevation (default is 90).")
    @In
    public double pElev = 90.0;
    @Description(value="The map of hillshade.")
    @UI(value="outfile")
    @In
    public String outHill;

    @Execute
    public void process() throws Exception {
        OmsHillshade hillshade = new OmsHillshade();
        hillshade.inElev = this.getRaster(this.inElev);
        hillshade.pMinDiffuse = this.pMinDiffuse;
        hillshade.pAzimuth = this.pAzimuth;
        hillshade.pElev = this.pElev;
        hillshade.pm = this.pm;
        hillshade.doProcess = this.doProcess;
        hillshade.doReset = this.doReset;
        hillshade.process();
        this.dumpRaster(hillshade.outHill, this.outHill);
    }
}

