/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorconverter.OmsLasConverter;

@Description(value="Coverter from LAS to vector point data.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Feature, Vector, Convert")
@Label(value="Vector Processing")
@Name(value="lasconverter")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasConverter
extends HMModel {
    @Description(value="The LAS file.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="A vector map of polygons to filter the data on.")
    @UI(value="infile_vector")
    @In
    public String inPolygons;
    @Description(value="The (min, max) range inside which the values should be taken.")
    @In
    public String pIntensityrange;
    @Description(value="The comma separated list of impulses values to keep.")
    @In
    public String pImpulses;
    @Description(value="The comma separated list of classes to keep.")
    @In
    public String pClasses;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="Only print header and exit (default is false).")
    @In
    public boolean doHeader = false;
    @Description(value="Print additional info and exit (default is false).")
    @In
    public boolean doInfo = false;
    @Description(value="Generate a bounding box polygon as output vector (default is false).")
    @In
    public boolean doBbox = false;
    @Description(value="The output file (csv, shp, las).")
    @UI(value="outfile")
    @In
    public String outFile;

    @Execute
    public void process() throws Exception {
        OmsLasConverter lasconverter = new OmsLasConverter();
        lasconverter.inFile = this.inFile;
        lasconverter.inPolygons = this.getVector(this.inPolygons);
        lasconverter.pIntensityrange = this.pIntensityrange;
        lasconverter.pImpulses = this.pImpulses;
        lasconverter.pClasses = this.pClasses;
        lasconverter.pNorth = this.pNorth;
        lasconverter.pSouth = this.pSouth;
        lasconverter.pWest = this.pWest;
        lasconverter.pEast = this.pEast;
        lasconverter.doHeader = this.doHeader;
        lasconverter.doInfo = this.doInfo;
        lasconverter.doBbox = this.doBbox;
        lasconverter.outFile = this.outFile;
        lasconverter.pm = this.pm;
        lasconverter.process();
    }

    public static void main(String[] args) throws Exception {
        LasConverter lasconverter = new LasConverter();
        lasconverter.inFile = "/home/hydrologis/TMP/GEOLOGICO/las/5h689050990.las";
        lasconverter.outFile = "/home/hydrologis/TMP/GEOLOGICO/las/5h689050990_out.las";
        lasconverter.process();
    }
}

