/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import org.hortonmachine.gears.io.las.core.Las;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Cheker for las native liblas installation.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="las, native")
@Label(value="Vector Processing")
@Name(value="lasnativechecker")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasNativeChecker
extends HMModel {
    @Execute
    public void process() throws Exception {
        boolean supportsNative = Las.supportsNative();
        if (supportsNative) {
            this.pm.message("This installation supports native las\nreading and writing through the liblas project.");
        } else {
            String[] libraryPaths;
            this.pm.message("This installation does not support native las\nreading and writing through the liblas project.");
            this.pm.message("No native libraries could be found.");
            this.pm.message("The library path contains:");
            for (String path : libraryPaths = Las.getLibraryPaths()) {
                if (path.trim().length() <= 0) continue;
                this.pm.message(" - " + path);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new LasNativeChecker().process();
    }
}

