/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Initialize;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileTraversal;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(value="A module that iterates over files in a folder and organizes them into year/month/day folders.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="File")
@Label(value="List Data Reader")
@Name(value="_filesinfolderorganizer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class FilesInFolderOrganizer
extends HMModel {
    @Description(value="The folder on which to iterate")
    @UI(value="infolder")
    @In
    public String inFolder;
    @Description(value="The output folder")
    @UI(value="outfolder")
    @In
    public String inOutputFolder;
    @Description(value="Only count the files it would copy and exit")
    @In
    public boolean doCountOnly = true;
    @Description(value="An optional file filter (used when developing).")
    @In
    public FileFilter fileFilter = null;
    public static final String FilesInFolderOrganizer_DESCRIPTION = "A module that iterates over files in a folder and organizes them into year/month/day folders.";
    public static final String FilesInFolderOrganizer_DOCUMENTATION = "";
    public static final String FilesInFolderOrganizer_KEYWORDS = "File";
    public static final String FilesInFolderOrganizer_LABEL = "List Data Reader";
    public static final String FilesInFolderOrganizer_NAME = "filesinfolderorganizer";
    public static final int FilesInFolderOrganizer_STATUS = 10;
    public static final String FilesInFolderOrganizer_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String FilesInFolderOrganizer_AUTHORNAMES = "Andrea Antonello";
    public static final String FilesInFolderOrganizer_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String FilesInFolderOrganizer_IN_FOLDER_DESCRIPTION = "The folder on which to iterate";
    public static final String FilesInFolderOrganizer_OUT_FOLDER_DESCRIPTION = "The output folder";
    public static final String FilesInFolderOrganizer_FILE_FILTER_DESCRIPTION = "An optional file filter (used when developing).";
    public static final String FilesInFolderOrganizer_doCountOnly_DESCRIPTION = "Only count the files it would copy and exit";
    private boolean doMonthNames = true;

    @Initialize
    public void initProcess() {
        this.doProcess = true;
    }

    @Execute
    public void process() throws Exception {
        this.checkFileExists(new String[]{this.inOutputFolder});
        final ArrayList pathsList = new ArrayList();
        new FileTraversal(this.fileFilter){

            public void onFile(File f) {
                pathsList.add(f.getAbsolutePath());
            }
        }.traverse(new File(this.inFolder));
        int filesNum = pathsList.size();
        this.pm.message("Files found to organize: " + filesNum);
        if (this.doCountOnly) {
            return;
        }
        DateTimeFormatter yearF = DateTimeFormat.forPattern((String)"yyyy");
        DateTimeFormatter monthF = DateTimeFormat.forPattern((String)"MM");
        DateTimeFormatter dayF = DateTimeFormat.forPattern((String)"dd");
        TreeMap year2Month2Day2AbsolutpathMap = new TreeMap();
        this.pm.beginTask("Sorting by creation date...", filesNum);
        for (String path : pathsList) {
            ArrayList<String> filesList;
            TreeMap<String, ArrayList<String>> day2AbsolutpathMap;
            long creationTimestamp = FileUtilities.getCreationTimestamp((String)path);
            DateTime dateTime = new DateTime(creationTimestamp);
            String year = dateTime.toString(yearF);
            String month = dateTime.toString(monthF);
            String dayOfMonth = dateTime.toString(dayF);
            TreeMap month2Day2AbsolutpathMap = (TreeMap)year2Month2Day2AbsolutpathMap.get(year);
            if (month2Day2AbsolutpathMap == null) {
                month2Day2AbsolutpathMap = new TreeMap();
                year2Month2Day2AbsolutpathMap.put(year, month2Day2AbsolutpathMap);
            }
            if ((day2AbsolutpathMap = (TreeMap<String, ArrayList<String>>)month2Day2AbsolutpathMap.get(month)) == null) {
                day2AbsolutpathMap = new TreeMap<String, ArrayList<String>>();
                month2Day2AbsolutpathMap.put(month, day2AbsolutpathMap);
            }
            if ((filesList = (ArrayList<String>)day2AbsolutpathMap.get(dayOfMonth)) == null) {
                filesList = new ArrayList<String>();
                day2AbsolutpathMap.put(dayOfMonth, filesList);
            }
            filesList.add(path);
            this.pm.worked(1);
        }
        this.pm.done();
        File outfolderFile = new File(this.inOutputFolder);
        this.pm.beginTask("Copy files to new locations...", filesNum);
        for (Map.Entry yearEntry : year2Month2Day2AbsolutpathMap.entrySet()) {
            String year = (String)yearEntry.getKey();
            TreeMap monthsMap = (TreeMap)yearEntry.getValue();
            for (Map.Entry monthEntry : monthsMap.entrySet()) {
                String month = (String)monthEntry.getKey();
                if (this.doMonthNames) {
                    switch (month) {
                        case "01": {
                            month = month + "_january";
                            break;
                        }
                        case "02": {
                            month = month + "_february";
                            break;
                        }
                        case "03": {
                            month = month + "_march";
                            break;
                        }
                        case "04": {
                            month = month + "_april";
                            break;
                        }
                        case "05": {
                            month = month + "_may";
                            break;
                        }
                        case "06": {
                            month = month + "_june";
                            break;
                        }
                        case "07": {
                            month = month + "_july";
                            break;
                        }
                        case "08": {
                            month = month + "_august";
                            break;
                        }
                        case "09": {
                            month = month + "_september";
                            break;
                        }
                        case "10": {
                            month = month + "_october";
                            break;
                        }
                        case "11": {
                            month = month + "_november";
                            break;
                        }
                        case "12": {
                            month = month + "_december";
                        }
                    }
                }
                TreeMap daysMap = (TreeMap)monthEntry.getValue();
                for (Map.Entry dayEntry : daysMap.entrySet()) {
                    String day = (String)dayEntry.getKey();
                    List pathslist = (List)dayEntry.getValue();
                    String newRelativePath = year + File.separator + month + File.separator + day + File.separator;
                    for (String p : pathslist) {
                        File fromFile = new File(p);
                        File toFile = new File(outfolderFile, newRelativePath + fromFile.getName());
                        if (toFile.exists()) {
                            long toLength;
                            long fromLength = fromFile.length();
                            if (fromLength == (toLength = toFile.length())) {
                                this.pm.errorMessage("File has duplicate: " + fromFile.getName());
                                this.pm.worked(1);
                                continue;
                            }
                            throw new ModelsIOException("Two files with same timestamp/name but different size were found: " + fromFile.getName(), (Object)this);
                        }
                        toFile.getParentFile().mkdirs();
                        FileUtilities.copyFile((File)fromFile, (File)toFile);
                        this.pm.worked(1);
                    }
                }
            }
        }
        this.pm.done();
    }

    public static void createImageGallery(String basePath) throws IOException {
        InputStream htmlStream = FilesInFolderOrganizer.class.getResourceAsStream("/gallery.html");
        String htmlString = FileUtilities.readInputStreamToString((InputStream)htmlStream);
        File baseFile = new File(basePath);
        File[] yearsFolderFiles = baseFile.listFiles(file -> {
            String yearName = file.getName();
            try {
                Integer.parseInt(yearName);
            }
            catch (Exception e) {
                return false;
            }
            return file.isDirectory();
        });
        StringBuilder sb = new StringBuilder();
        int n = 0;
        File[] fileArray = yearsFolderFiles;
        int n2 = fileArray.length;
        if (n < n2) {
            File yearFolder = fileArray[n];
            String year = yearFolder.getName();
            sb.append("<h1>Year: " + year + "</h1>\n");
            Object[] monthsFolderFiles = yearFolder.listFiles(file -> {
                String monthName = file.getName();
                try {
                    String monthNum = monthName.substring(0, 2);
                    Integer.parseInt(monthNum);
                }
                catch (Exception e) {
                    return false;
                }
                return file.isDirectory();
            });
            Arrays.sort(monthsFolderFiles);
            for (Object monthFolder : monthsFolderFiles) {
                String month = ((File)monthFolder).getName();
                sb.append("<h2>Month: " + month + "</h2>\n");
                Object[] daysFolderFiles = ((File)monthFolder).listFiles(file -> {
                    String dayName = file.getName();
                    try {
                        Integer.parseInt(dayName);
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return file.isDirectory();
                });
                Arrays.sort(daysFolderFiles);
                for (Object dayFolder : daysFolderFiles) {
                    String day = ((File)dayFolder).getName();
                    sb.append("<h3>Day: " + day + "</h3>\n");
                    Object[] imageFiles = ((File)dayFolder).listFiles(file -> {
                        String imageName = file.getName();
                        return file.isFile() && imageName.toLowerCase().endsWith("jpg");
                    });
                    Arrays.sort(imageFiles);
                    for (Object imageFile : imageFiles) {
                        String imageName = ((File)imageFile).getName();
                        String path = "./" + year + "/" + month + "/" + day + "/" + imageName;
                        sb.append("<a title=\"" + imageName + "\"");
                        sb.append(" href=\"" + path + "\">");
                        sb.append("<img alt=\"\"");
                        sb.append("src=\"" + path + "\" width=\"30%\" height=\"30%\" />");
                        sb.append("</a>\n");
                    }
                }
            }
        }
        htmlString = htmlString.replaceFirst("REPLACETEXT", sb.toString());
        FileUtilities.writeFile((String)htmlString, (File)new File(basePath + File.separator + "gallery.html"));
    }

    public static void main(String[] args) throws Exception {
        String outputFoler = "/home/hydrologis/Dropbox/cas/FOTO/";
        FilesInFolderOrganizer.createImageGallery(outputFoler);
    }
}

