/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.scanline.OmsScanLineRasterizer;

@Description(value="Module for polygon vector to raster conversion.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Rasterize")
@Label(value="Raster Processing")
@Name(value="_rscanline")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class ScanLineRasterizer
extends HMModel {
    @Description(value="The vector to rasterize.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The value to use as raster value if no field is given.")
    @In
    public Double pValue = null;
    @Description(value="The field to use to retrieve the category value for the raster.")
    @In
    public String fCat = null;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsScanLineRasterizer scanlinerasterizer = new OmsScanLineRasterizer();
        scanlinerasterizer.inVector = this.getVector(this.inVector);
        scanlinerasterizer.pValue = this.pValue;
        scanlinerasterizer.fCat = this.fCat;
        scanlinerasterizer.pNorth = this.pNorth;
        scanlinerasterizer.pSouth = this.pSouth;
        scanlinerasterizer.pWest = this.pWest;
        scanlinerasterizer.pEast = this.pEast;
        scanlinerasterizer.pRows = this.pRows;
        scanlinerasterizer.pCols = this.pCols;
        scanlinerasterizer.pm = this.pm;
        scanlinerasterizer.doProcess = this.doProcess;
        scanlinerasterizer.doReset = this.doReset;
        scanlinerasterizer.process();
        this.dumpRaster(scanlinerasterizer.outRaster, this.outRaster);
    }
}

