/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.basin.basinshape.OmsBasinShape;

@Description(value="Creates a Feature collection of the subbasins created with the netnumbering module.")
@Author(name="Erica Ghesla, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Basin, Geomorphology")
@Label(value="HortonMachine/Basin")
@Name(value="basinshape")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class BasinShape
extends HMModel {
    @Description(value="The elevation map.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of the numbered basins.")
    @UI(value="infile_raster")
    @In
    public String inBasins = null;
    @Description(value="The extracted basins vector map.")
    @UI(value="outfile")
    @In
    public String outBasins = null;

    @Execute
    public void process() throws Exception {
        OmsBasinShape basinShape = new OmsBasinShape();
        basinShape.inElev = this.getRaster(this.inElev);
        basinShape.inBasins = this.getRaster(this.inBasins);
        basinShape.pm = this.pm;
        basinShape.process();
        this.dumpVector(basinShape.outBasins, this.outBasins);
    }
}

