/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectoroperations.OmsBuffer;

@Description(value="A module that performs a buffer operation on a vector layer.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, OmsBuffer")
@Label(value="Vector Processing")
@Name(value="_vbuffer")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Buffer
extends HMModel {
    @Description(value="The input vector map.")
    @UI(value="infile_vector")
    @In
    public String inMap = null;
    @Description(value="The buffer distance.")
    @In
    public double pBuffer = 10.0;
    @Description(value="Flag to toggle singlesided buffer.")
    @In
    public boolean doSinglesided = false;
    @Description(value="The join style to use.")
    @UI(value="combo:round,mitre,bevel")
    @In
    public String pJoinstyle = "round";
    @Description(value="The cap style to use.")
    @UI(value="combo:round,flat,square")
    @In
    public String pCapstyle = "round";
    @Description(value="The buffered vector map.")
    @UI(value="outfile")
    @In
    public String outMap = null;

    @Execute
    public void process() throws Exception {
        OmsBuffer buffer = new OmsBuffer();
        buffer.inMap = this.getVector(this.inMap);
        buffer.pBuffer = this.pBuffer;
        buffer.doSinglesided = this.doSinglesided;
        buffer.pJoinstyle = this.pJoinstyle;
        buffer.pCapstyle = this.pCapstyle;
        buffer.pm = this.pm;
        buffer.process();
        this.dumpVector(buffer.outMap, this.outMap);
    }
}

