/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.demmanipulation.wateroutlet.OmsExtractBasin;

@Description(value="Extract a basin from a map of flowdirections.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="Dem manipulation, Basin, OmsFlowDirections")
@Label(value="HortonMachine/Dem Manipulation")
@Name(value="_extractbasin")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class ExtractBasin
extends HMModel {
    @Description(value="The northern coordinate of the watershed outlet.")
    @UI(value="northing")
    @In
    public double pNorth = -1.0;
    @Description(value="The eastern coordinate of the watershed outlet.")
    @UI(value="easting")
    @In
    public double pEast = -1.0;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow;
    @Description(value="A user supplied network map. If available, the outlet point is snapped to it before extracting the basin.")
    @UI(value="infile_vector")
    @In
    public String inNetwork;
    @Description(value="A buffer to consider for network snapping.")
    @In
    public double pSnapbuffer = 200.0;
    @Description(value="Flag to enable vector basin smoothing.")
    @In
    public boolean doSmoothing = false;
    @Description(value="The area of the extracted basin.")
    @Out
    public double outArea = 0.0;
    @Description(value="The extracted basin mask.")
    @UI(value="outfile")
    @In
    public String outBasin = null;
    @Description(value="The optional outlet point vector map.")
    @UI(value="outfile")
    @In
    public String outOutlet = null;
    @Description(value="The optional extracted basin vector map.")
    @UI(value="outfile")
    @In
    public String outVectorBasin = null;

    @Execute
    public void process() throws Exception {
        OmsExtractBasin extractbasin = new OmsExtractBasin();
        extractbasin.pNorth = this.pNorth;
        extractbasin.pEast = this.pEast;
        extractbasin.inFlow = this.getRaster(this.inFlow);
        extractbasin.inNetwork = this.getVector(this.inNetwork);
        extractbasin.pSnapbuffer = this.pSnapbuffer;
        boolean doVector = false;
        if (this.outVectorBasin != null) {
            doVector = true;
        }
        extractbasin.doVector = doVector;
        extractbasin.doSmoothing = this.doSmoothing;
        extractbasin.pm = this.pm;
        extractbasin.doProcess = this.doProcess;
        extractbasin.doReset = this.doReset;
        extractbasin.process();
        this.dumpRaster(extractbasin.outBasin, this.outBasin);
        this.dumpVector(extractbasin.outOutlet, this.outOutlet);
        this.dumpVector(extractbasin.outVectorBasin, this.outVectorBasin);
        this.outArea = extractbasin.outArea;
        this.pm.message("Basin Area = " + extractbasin.outArea);
    }
}

