/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.holefiller.OmsHoleFiller;

@Description(value="Module that fills raster holes using interpolation.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Holefiller, Raster")
@Label(value="Raster Processing")
@Name(value="holefiller")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class HoleFiller
extends HMModel {
    @Description(value="The raster to fill holes in.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The regions vector map on which to checkc for nulls.")
    @UI(value="infile_vector")
    @In
    public String inROI;
    @Description(value="The interpolation mode to use.")
    @UI(value="combo:TPS,IDW")
    @In
    public String pMode = "TPS";
    @Description(value="The buffer to use for interpolation.")
    @Unit(value="m")
    @In
    public double pBuffer = 4.0;
    @Description(value="The new raster.")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        OmsHoleFiller hf = new OmsHoleFiller();
        hf.inRaster = this.getRaster(this.inRaster);
        hf.inROI = this.getVector(this.inROI);
        hf.pMode = this.pMode;
        hf.pBuffer = this.pBuffer;
        hf.pm = this.pm;
        hf.doProcess = this.doProcess;
        hf.doReset = this.doReset;
        hf.process();
        this.dumpRaster(hf.outRaster, this.outRaster);
    }
}

