/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.intensityclassifier.OmsIntensityClassifierFlood;

@Description(value="Module for the calculation of the flooding intensity.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Flooding")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_intensityclassifier")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class IntensityClassifierFlood
extends HMModel {
    @Description(value="The map of the water depth.")
    @UI(value="infile_raster")
    @Unit(value="m")
    @In
    public String inWaterDepth;
    @Description(value="The map of the water velocity.")
    @UI(value="infile_raster")
    @Unit(value="m/s")
    @In
    public String inVelocity;
    @Description(value="The upper threshold value for the water depth.")
    @Unit(value="m")
    @In
    public Double pUpperThresWaterdepth = 1.0;
    @Description(value="The upper threshold value for the product of water depth and velocity.")
    @Unit(value="m2/s")
    @In
    public Double pUpperThresVelocityWaterdepth = 1.0;
    @Description(value="The lower threshold value for the water depth.")
    @Unit(value="m")
    @In
    public Double pLowerThresWaterdepth = 0.5;
    @Description(value="The lower threshold value for the product of water depth and velocity.")
    @Unit(value="m2/s")
    @In
    public Double pLowerThresVelocityWaterdepth = 0.5;
    @Description(value="The map of flooding intensity.")
    @UI(value="outfile")
    @In
    public String outIntensity = null;

    @Execute
    public void process() throws Exception {
        OmsIntensityClassifierFlood intensityclassifier = new OmsIntensityClassifierFlood();
        intensityclassifier.inWaterDepth = this.getRaster(this.inWaterDepth);
        intensityclassifier.inVelocity = this.getRaster(this.inVelocity);
        intensityclassifier.pUpperThresWaterdepth = this.pUpperThresWaterdepth;
        intensityclassifier.pUpperThresVelocityWaterdepth = this.pUpperThresVelocityWaterdepth;
        intensityclassifier.pLowerThresWaterdepth = this.pLowerThresWaterdepth;
        intensityclassifier.pLowerThresVelocityWaterdepth = this.pLowerThresVelocityWaterdepth;
        intensityclassifier.pm = this.pm;
        intensityclassifier.doProcess = this.doProcess;
        intensityclassifier.doReset = this.doReset;
        intensityclassifier.process();
        this.dumpRaster(intensityclassifier.outIntensity, this.outIntensity);
    }
}

