/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.LWFields;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW11_NetworkPropagator;

@Description(value="Label the critical section for the transit of the wood and calculate the cumulated volume of biomass in each blocking section.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Keywords(value="critical, wood")
@Name(value="_lw11_networkpropagator")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW11_NetworkPropagator
extends HMModel
implements LWFields {
    @Description(value="The input network points layer with the additional attributes vegetation height and timber volume.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The ratio between the lenght of the logs and the maximum channel width for the vegetation coming from the hillslopes (vegetation characteristics of the current section).")
    @In
    public double pRatioLogsLengthChannelWidthHillslope = 0.8;
    @Description(value="The ratio between the lenght of the logs and the maximum channel width for the vegetation coming from upstream (vegetation characteristics from upstream not blocked).")
    @In
    public double pRatioLogsLengthChannelWidthChannel = 1.0;
    @Description(value="The ratio between the diameter of the logs and the water depth corresponding to maximum channel widht.")
    @In
    public double pRatioLogsDiameterWaterDepth = 0.8;
    @Description(value="The output network points layer with the critical sections labelled in the attribute table.")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;

    @Execute
    public void process() throws Exception {
        OmsLW11_NetworkPropagator ex = new OmsLW11_NetworkPropagator();
        ex.inNetPoints = this.getVector(this.inNetPoints);
        ex.pRatioLogsDiameterWaterDepth = this.pRatioLogsDiameterWaterDepth;
        ex.pRatioLogsLengthChannelWidthChannel = this.pRatioLogsLengthChannelWidthChannel;
        ex.pRatioLogsLengthChannelWidthHillslope = this.pRatioLogsLengthChannelWidthHillslope;
        ex.process();
        this.dumpVector(ex.outNetPoints, this.outNetPoints);
    }
}

