/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.summary.OmsRasterSummary;

@Description(value="Calculate a summary of the map with base statistics.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Statistics, Raster, OmsMapcalc")
@Label(value="Raster Processing")
@Name(value="_rsummary")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterSummary
extends HMModel {
    @Description(value="The map to analize.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The number of bins for the histogram (default = 100).")
    @In
    public int pBins = 100;
    @Description(value="Flag that defines if the histogram should be done also (default = false).")
    @In
    public boolean doHistogram = false;
    @Description(value="The min value.")
    @Out
    public Double outMin = null;
    @Description(value="The max value.")
    @Out
    public Double outMax = null;
    @Description(value="The mean value.")
    @Out
    public Double outMean = null;
    @Description(value="The standard deviation value.")
    @Out
    public Double outSdev = null;
    @Description(value="The range value.")
    @Out
    public Double outRange = null;
    @Description(value="The sum value.")
    @Out
    public Double outSum = null;
    @Description(value="The histogram.")
    @Out
    public double[][] outCb = null;

    @Execute
    public void process() throws Exception {
        OmsRasterSummary rastersummary = new OmsRasterSummary();
        rastersummary.inRaster = this.getRaster(this.inRaster);
        rastersummary.pBins = this.pBins;
        rastersummary.doHistogram = this.doHistogram;
        rastersummary.pm = this.pm;
        rastersummary.doProcess = this.doProcess;
        rastersummary.doReset = this.doReset;
        rastersummary.process();
        this.outMin = rastersummary.outMin;
        this.outMax = rastersummary.outMax;
        this.outMean = rastersummary.outMean;
        this.outSdev = rastersummary.outSdev;
        this.outRange = rastersummary.outRange;
        this.outSum = rastersummary.outSum;
        this.outCb = rastersummary.outCb;
    }
}

