/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Vectors features reader module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="_vectorreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorReader
extends HMModel {
    @Description(value="The vector file to read.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @In
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws IOException {
        OmsVectorReader vectorreader = new OmsVectorReader();
        vectorreader.file = this.file;
        vectorreader.pm = this.pm;
        vectorreader.doProcess = this.doProcess;
        vectorreader.doReset = this.doReset;
        vectorreader.process();
        this.outVector = vectorreader.outVector;
    }

    public static SimpleFeatureCollection readVector(String path) throws IOException {
        return OmsVectorReader.readVector((String)path);
    }
}

