/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.vectorsimplifier.OmsVectorSimplifier;

@Description(value="Collection of vector simplification algorithms.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Simplify, OmsLineSmootherMcMaster, OmsLineSmootherJaitools")
@Label(value="Vector Processing")
@Name(value="_vsimplify")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class VectorSimplifier
extends HMModel {
    @Description(value="The vector to be simplified.")
    @UI(value="infile_vector")
    @In
    public String inVector;
    @Description(value="The simplification type: TopologyPreservingSimplifier = 0, Douglas Peucker = 1 (default = 0).")
    @In
    public int pType = 0;
    @Description(value="The distance tolerance for the simplification.")
    @In
    public double pTolerance = 0.2;
    @Description(value="The simplified vector.")
    @UI(value="outfile")
    @In
    public String outVector;

    @Execute
    public void process() throws Exception {
        OmsVectorSimplifier vectorsimplifier = new OmsVectorSimplifier();
        vectorsimplifier.inVector = this.getVector(this.inVector);
        vectorsimplifier.pType = this.pType;
        vectorsimplifier.pTolerance = this.pTolerance;
        vectorsimplifier.pm = this.pm;
        vectorsimplifier.doProcess = this.doProcess;
        vectorsimplifier.doReset = this.doReset;
        vectorsimplifier.process();
        this.dumpVector(vectorsimplifier.outVector, this.outVector);
    }
}

