/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.eicalculator.OmsEIAltimetryReader;
import org.hortonmachine.gears.io.eicalculator.OmsEIAreasReader;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorReader;
import org.hortonmachine.gears.io.timedependent.OmsTimeSeriesIteratorWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.statistics.jami.OmsJami;

@Description(value="Jami - Just another meteo interpolator")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Meteo, Hydrology")
@Label(value="HortonMachine/Statistics")
@Name(value="_jami")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Jami
extends HMModel {
    @Description(value="The features representing the meteo stations and containing the position information as well as the elevation. Every feature has a unique id that is used to map the meteo data records to it.")
    @UI(value="infile_vector")
    @In
    public String inStations;
    @Description(value="The field name of the attribute table that holds the station id.")
    @In
    public String fStationid;
    @Description(value="The field name of the attribute table that holds the station elevation.")
    @In
    public String fStationelev;
    @Description(value="The bins into which to divide the vertical range of stations in order to define levels.")
    @In
    public int pBins = 4;
    @Description(value="The minimum number of stations required at a certain level, to perform interpolation.")
    @In
    public int pNum = 3;
    @Description(value="The features representing the points in which the meteo data will be interpolated to. The baricenter of the basin is used to place the result ofthe interpolation. These can be of any shape, the baricenter will be used anyways.")
    @UI(value="infile_vector")
    @In
    public String inInterpolate;
    @Description(value="The field name of the attribute table that holds the basin id.")
    @In
    public String fBasinid;
    @Description(value="The meteo type that will be handled for interpolation [0 = temp, 1 = pressure, 2 = humidity, 3 = wind, 4 = DTDAY, 5 = DTMONTH].")
    @In
    public int pType = -1;
    @Description(value="The default value for relative humidity: 70%")
    @Unit(value="%")
    @In
    public double defaultRh = 70.0;
    @Description(value="The default value for wind speed: 1 m/s")
    @Unit(value="m/s")
    @In
    public double defaultW = 1.0;
    @Description(value="The hour of the day in which Tmin is supposed to happen.")
    @Unit(value="hours")
    @In
    public double pHtmin = 5.0;
    @Description(value="The hour of the day in which Tmax is supposed to happen.")
    @Unit(value="hours")
    @In
    public double pHtmax = 13.0;
    @Description(value="Dayly temperature range.")
    @Unit(value="celsius degrees")
    @In
    public double defaultDtday = 7.0;
    @Description(value="Monthly temperature range.")
    @Unit(value="celsius degrees")
    @In
    public double defaultDtmonth = 7.0;
    @Description(value="Number of hours of tollerance in Tmin")
    @Unit(value="hours")
    @In
    public double defaultTolltmin = 2.0;
    @Description(value="Number of hours of tollerance in Tmax")
    @Unit(value="hours")
    @In
    public double defaultTolltmax = 2.0;
    @Description(value="The list of altimetric bands information, into which the basin is divided.")
    @UI(value="infile_csv")
    @In
    public String inAltimetry = null;
    @Description(value="The list of altimetric/energetic bands areas.")
    @UI(value="infile_csv")
    @In
    public String inAreas = null;
    @Description(value="The map of meteo data to interpolate. Every value is associated to the id of the station.")
    @UI(value="infile_csv")
    @In
    public String inMeteo = null;
    @Description(value="Output interpolated meteo data for every band and point. Every value is associated to the id of the interpolation point.")
    @UI(value="outfile")
    @In
    public String outInterpolatedBand = null;
    @Description(value="Output interpolated meteo data for every point. Every value is associated to the id of the interpolation point.")
    @UI(value="outfile")
    @In
    public String outInterpolated = null;

    @Execute
    public void process() throws Exception {
        OmsEIAltimetryReader altim = new OmsEIAltimetryReader();
        altim.file = this.inAltimetry;
        altim.pSeparator = ",";
        altim.pm = this.pm;
        altim.read();
        List altimList = altim.outAltimetry;
        altim.close();
        OmsEIAreasReader areas = new OmsEIAreasReader();
        areas.file = this.inAreas;
        areas.pSeparator = ",";
        areas.pm = this.pm;
        areas.read();
        List areasList = areas.outAreas;
        areas.close();
        OmsTimeSeriesIteratorReader dataReader = new OmsTimeSeriesIteratorReader();
        dataReader.file = this.inMeteo;
        dataReader.fileNovalue = "-9999";
        dataReader.idfield = this.fStationid;
        dataReader.initProcess();
        OmsJami omsjami = new OmsJami();
        omsjami.inStations = this.getVector(this.inStations);
        omsjami.fStationid = this.fStationid;
        omsjami.fStationelev = this.fStationelev;
        omsjami.pBins = this.pBins;
        omsjami.pNum = this.pNum;
        omsjami.inInterpolate = this.getVector(this.inInterpolate);
        omsjami.fBasinid = this.fBasinid;
        omsjami.pType = this.pType;
        omsjami.defaultRh = this.defaultRh;
        omsjami.defaultW = this.defaultW;
        omsjami.pHtmin = this.pHtmin;
        omsjami.pHtmax = this.pHtmax;
        omsjami.defaultDtday = this.defaultDtday;
        omsjami.defaultDtmonth = this.defaultDtmonth;
        omsjami.defaultTolltmin = this.defaultTolltmin;
        omsjami.defaultTolltmax = this.defaultTolltmax;
        omsjami.inAltimetry = altimList;
        omsjami.inAreas = areasList;
        omsjami.pm = this.pm;
        omsjami.doProcess = this.doProcess;
        omsjami.doReset = this.doReset;
        OmsTimeSeriesIteratorWriter writerInterpolated = null;
        OmsTimeSeriesIteratorWriter writerInterpolatedBand = null;
        this.pm.beginTask("Processing...", -1);
        while (dataReader.doProcess) {
            HashMap id2ValueMap;
            dataReader.nextRecord();
            if (writerInterpolated == null && this.outInterpolated != null) {
                writerInterpolated = new OmsTimeSeriesIteratorWriter();
                writerInterpolated.file = this.outInterpolated;
                writerInterpolated.tStart = dataReader.tStart;
                writerInterpolated.tTimestep = dataReader.tTimestep;
            }
            if (writerInterpolatedBand == null && this.outInterpolatedBand != null) {
                writerInterpolatedBand = new OmsTimeSeriesIteratorWriter();
                writerInterpolatedBand.file = this.outInterpolatedBand;
                writerInterpolatedBand.tStart = dataReader.tStart;
                writerInterpolatedBand.tTimestep = dataReader.tTimestep;
            }
            this.pm.message("timestep: " + dataReader.tCurrent);
            omsjami.tCurrent = dataReader.tCurrent;
            omsjami.inMeteo = id2ValueMap = dataReader.outData;
            omsjami.process();
            writerInterpolated.inData = omsjami.outInterpolated;
            writerInterpolated.writeNextLine();
            writerInterpolatedBand.inData = omsjami.outInterpolatedBand;
            writerInterpolatedBand.writeNextLine();
        }
        this.pm.done();
        dataReader.close();
        if (writerInterpolated != null) {
            writerInterpolated.close();
        }
        if (writerInterpolatedBand != null) {
            writerInterpolatedBand.close();
        }
    }
}

