/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.lwrecruitment.OmsLW10_CHM_AreaToNetpointAssociator;

@Description(value="Calculate median vegetation height and total timber volume of the vegetation on unstable and connected areas of each subbasin.")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="network, vector, bankflull, width, inundation, vegetation")
@Label(value="HortonMachine/Hydro-Geomorphology/LWRecruitment")
@Name(value="_lw10_areatonetpointassociator")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LW10_CHM_AreaToNetpointAssociator
extends HMModel {
    @Description(value="The input hierarchy point network layer.")
    @UI(value="infile_vector")
    @In
    public String inNetPoints = null;
    @Description(value="The input polygon layer with the inundation areas.")
    @UI(value="infile_vector")
    @In
    public String inInundationArea = null;
    @Description(value="The input flow directions raster map.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The input total contributing areas raster map.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The input network raster map.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The input terrain elevation raster map.")
    @UI(value="infile_raster")
    @In
    public String inDtm = null;
    @Description(value="The input superficial elevation raster map.")
    @UI(value="infile_raster")
    @In
    public String inDsm = null;
    @Description(value="The input total stand volume raster map.")
    @UI(value="infile_raster")
    @In
    public String inStand = null;
    @Description(value="The input downslope connectivity index raster map.")
    @UI(value="infile_raster")
    @In
    public String inConnectivity = null;
    @Description(value="Threshold on connectivity map for extracting unstable connected pixels of the basins.")
    @In
    public double pConnectivityThreshold = 4.0;
    @Description(value="The output points network layer with the additional attributes vegetation height and timber volume .")
    @UI(value="outfile")
    @In
    public String outNetPoints = null;
    @Description(value="The output netnumbering raster map.")
    @UI(value="outfile")
    @In
    public String outNetnum = null;
    @Description(value="The output subbasins raster map.")
    @UI(value="outfile")
    @In
    public String outBasins = null;

    @Execute
    public void process() throws Exception {
        OmsLW10_CHM_AreaToNetpointAssociator npa = new OmsLW10_CHM_AreaToNetpointAssociator();
        npa.inNetPoints = this.getVector(this.inNetPoints);
        npa.pm = this.pm;
        npa.inInundationArea = this.getVector(this.inInundationArea);
        npa.inFlow = this.getRaster(this.inFlow);
        npa.inTca = this.getRaster(this.inTca);
        npa.inNet = this.getRaster(this.inNet);
        npa.inDtm = this.getRaster(this.inDtm);
        npa.inDsm = this.getRaster(this.inDsm);
        npa.inStand = this.getRaster(this.inStand);
        npa.inConnectivity = this.getRaster(this.inConnectivity);
        npa.pConnectivityThreshold = this.pConnectivityThreshold;
        npa.process();
        this.dumpVector(npa.outNetPoints, this.outNetPoints);
        this.dumpRaster(npa.outNetnum, this.outNetnum);
        this.dumpRaster(npa.outBasins, this.outBasins);
    }
}

