/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.hydrogeomorphology.melton.OmsMeltonNumber;

@Description(value="Melton number calculator")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="Melton, Raster, Vector")
@Label(value="HortonMachine/Hydro-Geomorphology")
@Name(value="_meltonnum")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class MeltonNumber
extends HMModel {
    @Description(value="The map of elevation.")
    @UI(value="infile_raster")
    @In
    public String inElev = null;
    @Description(value="The map of polygons of the fans.")
    @UI(value="infile_vector")
    @In
    public String inFans = null;
    @Description(value="The fields of the polygons containing the id of the polygon.")
    @In
    public String fId;
    @Description(value="The Melton numbers per id [id, num].")
    @In
    public String[][] outMelton = null;

    @Execute
    public void process() throws Exception {
        OmsMeltonNumber meltonnumber = new OmsMeltonNumber();
        meltonnumber.inElev = this.getRaster(this.inElev);
        meltonnumber.inFans = this.getVector(this.inFans);
        meltonnumber.fId = this.fId;
        meltonnumber.pm = this.pm;
        meltonnumber.doProcess = this.doProcess;
        meltonnumber.doReset = this.doReset;
        meltonnumber.process();
        this.outMelton = meltonnumber.outMelton;
    }
}

