/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.network.netnumbering.OmsNetNumbering;

@Description(value="Assigns the numbers to the network's links.")
@Author(name="Antonello Andrea, Franceschi Silvia, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Network, SplitSubbasins")
@Label(value="HortonMachine/Network")
@Name(value="_netnum")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class NetNumbering
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of total contributing area.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The map of the network.")
    @UI(value="infile_raster")
    @In
    public String inNet = null;
    @Description(value="The monitoringpoints vector map.")
    @UI(value="infile_vector")
    @In
    public String inPoints = null;
    @Description(value="Threshold value on tca map.")
    @In
    public int pThres = 0;
    @Description(value="The name of the node id field in mode 2.")
    @In
    public String fPointId = null;
    @Description(value="The map of netnumbering")
    @UI(value="outfile")
    @In
    public String outNetnum = null;
    @Description(value="The map of subbasins")
    @UI(value="outfile")
    @In
    public String outBasins = null;

    @Execute
    public void process() throws Exception {
        OmsNetNumbering omsnetnumbering = new OmsNetNumbering();
        omsnetnumbering.inFlow = this.getRaster(this.inFlow);
        omsnetnumbering.inTca = this.getRaster(this.inTca);
        omsnetnumbering.inNet = this.getRaster(this.inNet);
        omsnetnumbering.inPoints = this.getVector(this.inPoints);
        omsnetnumbering.pThres = this.pThres;
        omsnetnumbering.pm = this.pm;
        omsnetnumbering.doProcess = this.doProcess;
        omsnetnumbering.doReset = this.doReset;
        omsnetnumbering.process();
        this.dumpRaster(omsnetnumbering.outNetnum, this.outNetnum);
        this.dumpRaster(omsnetnumbering.outBasins, this.outBasins);
    }
}

