/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.v.rastercattofeatureattribute.OmsRasterCatToFeatureAttribute;

@Description(value="Module that extracts raster categories and adds them to a feature collection.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector")
@Label(value="Vector Processing")
@Name(value="_rat2featureattr")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterCatToFeatureAttribute
extends HMModel {
    @Description(value="The raster on which to map the vector features.")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="The vector to use for the geometric mapping.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="The name for the new field to create.")
    @In
    public String fNew = "new";
    @Description(value="The position of the coordinate to take in the case of multi geometries.")
    @In
    public String pPos = "middle";
    @Description(value="The extended vector.")
    @UI(value="outfile")
    @In
    public String outVector = null;

    @Execute
    public void process() throws Exception {
        OmsRasterCatToFeatureAttribute rastercattofeatureattribute = new OmsRasterCatToFeatureAttribute();
        rastercattofeatureattribute.inRaster = this.getRaster(this.inRaster);
        rastercattofeatureattribute.inVector = this.getVector(this.inVector);
        rastercattofeatureattribute.fNew = this.fNew;
        rastercattofeatureattribute.pPos = this.pPos;
        rastercattofeatureattribute.pm = this.pm;
        rastercattofeatureattribute.doProcess = this.doProcess;
        rastercattofeatureattribute.doReset = this.doReset;
        rastercattofeatureattribute.process();
        this.dumpVector(rastercattofeatureattribute.outVector, this.outVector);
    }
}

