/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.GeneralEnvelope;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.libs.modules.HMModel;

@Description(value="Raster reader module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Reading")
@Label(value="Raster Reader")
@Name(value="_rasterreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class RasterReader
extends HMModel {
    @Description(value="The raster file to read with extension (supported are: asc, tiff, grass).")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The file novalue.")
    @In
    public Double fileNovalue = -9999.0;
    @Description(value="The novalue wanted in the raster.")
    @In
    public Double geodataNovalue = -9999.0;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The optional requested resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The optional requested resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The optional requested numer of rows.")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The optional requested numer of cols.")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="Optional flag to force a legacy GRASS driver usage.")
    @In
    public Boolean doLegacyGrass = false;
    @Description(value="The read output raster map.")
    @In
    public GridCoverage2D outRaster = null;
    public boolean doEnvelope = false;
    public GeneralEnvelope originalEnvelope;

    @Execute
    public void process() throws Exception {
        OmsRasterReader rasterreader = new OmsRasterReader();
        rasterreader.file = this.file;
        rasterreader.fileNovalue = this.fileNovalue;
        rasterreader.geodataNovalue = this.geodataNovalue;
        rasterreader.pNorth = this.pNorth;
        rasterreader.pSouth = this.pSouth;
        rasterreader.pWest = this.pWest;
        rasterreader.pEast = this.pEast;
        rasterreader.pXres = this.pXres;
        rasterreader.pYres = this.pYres;
        rasterreader.pRows = this.pRows;
        rasterreader.pCols = this.pCols;
        rasterreader.doLegacyGrass = this.doLegacyGrass;
        rasterreader.doEnvelope = this.doEnvelope;
        rasterreader.pm = this.pm;
        rasterreader.doProcess = this.doProcess;
        rasterreader.doReset = this.doReset;
        rasterreader.process();
        this.outRaster = rasterreader.outRaster;
        this.originalEnvelope = rasterreader.originalEnvelope;
    }

    public static GridCoverage2D readRaster(String path) throws Exception {
        return OmsRasterReader.readRaster((String)path);
    }
}

