/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.tca.OmsTca;

@Description(value="Calculates the contributing areas that represent the areas (in number of pixels) afferent to each point.")
@Author(name="Antonello Andrea", contact="http://www.hydrologis.com")
@Keywords(value="Geomorphology, OmsDrainDir, Tca3D, OmsAb, Multitca")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_tca")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class Tca
extends HMModel {
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of total contributing areas.")
    @UI(value="outfile")
    @In
    public String outTca = null;
    @Description(value="The vector containing loops, if there are any.")
    @UI(value="outfile")
    @In
    public String outLoop = null;

    @Execute
    public void process() throws Exception {
        OmsTca omstca = new OmsTca();
        omstca.inFlow = this.getRaster(this.inFlow);
        omstca.pm = this.pm;
        omstca.doProcess = this.doProcess;
        omstca.doReset = this.doReset;
        omstca.process();
        this.dumpRaster(omstca.outTca, this.outTca);
        this.dumpVector(omstca.outLoop, this.outLoop);
    }
}

