/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.hmachine.modules.geomorphology.tca3d.OmsTca3d;

@Description(value="Calculates the contributing areas considering also the elevation (3D), that represent the areas (in number of pixels) afferent to each point.")
@Author(name="Daniele Andreis, Antonello Andrea, Erica Ghesla, Cozzini Andrea, Franceschi Silvia, Pisoni Silvano, Rigon Riccardo", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsDrainDir, OmsTca, OmsAb, Multitca")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_tca3d")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Tca3d
extends HMModel {
    @Description(value="The depitted elevation model.")
    @UI(value="infile_raster")
    @In
    public String inPit = null;
    @Description(value="The map of flowdirections.")
    @UI(value="infile_raster")
    @In
    public String inFlow = null;
    @Description(value="The map of total contributing areas 3d.")
    @UI(value="outfile")
    @In
    public String outTca = null;

    @Execute
    public void process() throws Exception {
        OmsTca3d tca3d = new OmsTca3d();
        tca3d.inPit = this.getRaster(this.inPit);
        tca3d.inFlow = this.getRaster(this.inFlow);
        tca3d.pm = this.pm;
        tca3d.doProcess = this.doProcess;
        tca3d.doReset = this.doReset;
        tca3d.process();
        this.dumpRaster(tca3d.outTca, this.outTca);
    }
}

